<?php
$config = ModuleLoader::getConfig("epaper");        
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
        
$image_path = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$model->pg_file;
$image_url = Yii::app()->getBaseUrl(true).$uploadDir.$mediaDir.$model->pg_file;
$wimg = WideImage::load($image_path);
$image_width = $wimg->getWidth(); 
?>
<style>
    #canvas{
        position:relative;
        width:800px;
    }
    .area{
        position:absolute;
        width: 150px; height: 150px; padding: 5px;
        border:1px solid gray;
        background-color:rgba(0,0,0,0.3);
        color:white;
        cursor: move;
        z-index:10;
    }
    .ui-resizable-handle {
        width: 10px;
        height: 10px;
        background-color: #ffffff;
        border: 1px solid #000000;
        position:absolute;

    }
    .ui-resizable-n{
        top: -10px;
        left:50%;

    }
    .ui-resizable-e
    {
        right:-10px;
        top:50%;    
    }
    .ui-resizable-s
    {
        bottom: -10px;
        left: 50%;
    }

    .ui-resizable-w
    {
        left:-10px;
        top:50%;
    }

    .ui-resizable-nw
    {
        left: -10px;
        top: -10px;    
    }
    .ui-resizable-ne
    {
        top: -10px;
        right: -10px; 
    }
    .ui-resizable-sw
    {
        bottom: -10px;
        left: -10px;
    }
    .ui-resizable-se
    {
        bottom: -10px;
        right: -10px;
    }
    .p_x, .p_y, .p_w, .p_h{
        display:none;
    }
</style>
<a class="btn btn-info" href="<?php echo $this->createUrl("index",array("ed_id"=>$model->ed_id)); ?>">&lt;&lt; Back</a>
<button name="btnTool" id="btnTool" class="btn btn-danger">
    Add Area Map +
</button>
<button name="btnSave" id="btnSave" class="btn btn-primary">
    Save
</button>
<div id="canvas">    

<?php 
    $n = 1;
    if(trim($model->pg_cdata)!=""){
        $cdata = unserialize($model->pg_cdata);  
        $ratio = $cdata["ratio"];
        foreach($cdata["area"] as $c){
            
            $title = "";
            if(isset($c["title"])){
                $title = str_replace(":","",$c["title"]);
            }
            
            echo '<div data-title="'.$title.'" data-id="'.$n.'" class="area" style="top: '.$c["y"]/$ratio.'px; left: '.$c["x"]/$ratio.'px; width: '.$c["w"]/$ratio.'px; height: '.$c["h"]/$ratio.'px;">' .
                            '<a href="#" class="btnEdit btn btn-success btn-xs"><span class="glyphicon glyphicon-pencil"></span></a> | <a href="#" class="btnDelete btn btn-danger btn-xs"><span class="glyphicon glyphicon-trash"></span></a> | <a href="#" class="btnView btn btn-primary btn-xs"><span class="glyphicon glyphicon-eye-open"></span></a> ' .
                            '<span class="p_x">'.$c["x"]/$ratio.'px</span>' .
                            '<span class="p_y">'.$c["y"]/$ratio.'px</span>' .                           
                            '<span class="p_w">'.$c["w"]/$ratio.'px</span>' .
                            '<span class="p_h">'.$c["h"]/$ratio.'px</span>' .
                            '</div>';
            $n++;
        }
    }
?>
    <img style="width:100%; height:auto"  src="<?php echo $image_url; ?>" />
</div>


<form id="formAreaData">
    <input type="hidden" name="pg_id" id="pg_id" value="<?php echo Yii::app()->request->getParam("id"); ?>" />
    <input type="hidden" name="ratio" id="ratio" value="1" />
    <?php 
    $n = 1;
    if(trim($model->pg_cdata)!=""){
        $cdata = unserialize($model->pg_cdata);    
        
        foreach($cdata["area"] as $c){
            
            $title = "";
            if(isset($c["title"])){
                $title = str_replace(":","",$c["title"]);
            }
            
            echo "<input type='hidden' name='area[".$n."]' id='area-".$n."' value='".$c["x"]/$ratio.":".$c["y"]/$ratio.":".$c["w"]/$ratio.":".$c["h"]/$ratio.":".$title."' />";
            $n++;
        }
    }
    ?>
    
</form>
        
        <script>
              
            var originalSize = "<?php echo $image_width; ?>";
            var canvasSize = parseInt($("#canvas").css("width"));
            var ratio = originalSize/canvasSize;
            $("#ratio").val(ratio);
            
            var n = <?php echo $n; ?>;
            $(document).ready(function() {
                   doit();
                $("#btnSave").on("click",function(){
                    $.ajax({
                        url:"<?php echo $this->createUrl("savepagedata"); ?>",                        
                        data:$("#formAreaData").serialize(),
                        success:function(data){
                            alert("Saved");
                        }
                    })
                });
                
                $(document).on("click", ".btnDelete", function(e) {
                    var id = $(this).parent().attr("data-id");                    
                    $("#area-"+id).remove();
                    $(this).parent().remove();                    
                    return false;
                });
                
                $(document).on("click", ".btnEdit", function(e) {
                    e.preventDefault();
                    var title = $(this).parent().attr("data-title");
                    var new_title = prompt("Enter the title (Please do not enter ':')",title);
                    if(new_title !== null){
                        new_title = new_title.replace(/:/g,"").replace(/(<([^>]+)>)/ig,"");
                        $(this).parent().attr("data-title",new_title);                    
                        var id = $(this).parent().attr("data-id");
                        var area_data = $("#area-"+id).val().split(":");
                        area_data[4] = new_title;                    
                        var new_area_data = area_data.join(":");
                        $("#area-"+id).val(new_area_data);
                    }
                });
                
                $(document).on("click", ".btnView", function(e) {
                    var x = parseInt($(this).parent().children(".p_x").html()) * ratio;
                    var y = parseInt($(this).parent().children(".p_y").html()) * ratio;
                    var w = parseInt($(this).parent().children(".p_w").html()) * ratio;
                    var h = parseInt($(this).parent().children(".p_h").html()) * ratio;
                    
                    var url = "<?php echo urldecode($this->createUrl("view",array("pg_id"=>$model->pg_id,"x"=>"[x]","y"=>"[y]","w"=>"[w]","h"=>"[h]"))); ?>"
                    url = url.replace("[x]",x);
                            url = url.replace("[y]",y);
                                    url = url.replace("[w]",w);
                                            url = url.replace("[h]",h);
                     
                    window.open(url,"_blank",'width='+w+',height='+h+',toolbar=0,menubar=0,location=0,status=1,scrollbars=1,resizable=1,left=0,top=0');
                    return false;
                });
                 
                $("#btnTool").on("click", function() {                    
                    var str = '<div data-title="" data-id="'+n+'" class="area">' +
                            '<a href="#" class="btnEdit btn btn-success btn-xs"><span class="glyphicon glyphicon-pencil"></span></a> | <a href="#" class="btnDelete btn btn-danger btn-xs"><span class="glyphicon glyphicon-trash"></span><a> | <a href="#" class="btnView btn btn-primary btn-xs"><span class="glyphicon glyphicon-eye-open"></span></a> ' +
                            '<span class="p_x">0px</span>' +
                            '<span class="p_y">0px</span>' +                           
                            '<span class="p_w">150px</span>' +
                            '<span class="p_h">150px</span>' +
                            '</div>';                    
                    $("#canvas").prepend(str);
                   
                    var inputstr = "<input type='hidden' name='area["+n+"]' id='area-"+n+"' value='0:0:150:150:' /> ";
                    $("#formAreaData").append(inputstr);
                    n++;
                    doit();
                });
                
                function doit(){
                    $(".area").resizable({
                        handles: "n, e, s, w, nw, ne, sw,se",
                         
                        resize: function() {
                            $(this).children(".p_x").html($(this).css("left"));
                            $(this).children(".p_y").html($(this).css("top"));
                            $(this).children(".p_w").html($(this).css("width"));
                            $(this).children(".p_h").html($(this).css("height"));
                            
                            var id = $(this).attr("data-id");
                            var title = $(this).attr("data-title");
                            var x = parseInt($(this).css("left"));
                            var y = parseInt($(this).css("top"));
                            var w = parseInt($(this).css("width"))+12;
                            var h = parseInt($(this).css("height"))+12;
                            
                            $(this).css("width",w);
                            $(this).css("height",h);
                            
                            $("#area-"+id).val(x+":"+y+":"+w+":"+h+":"+title);
                        }
                    }).draggable({
                         
                        drag: function() {
                            $(this).children(".p_x").html($(this).css("left"));
                            $(this).children(".p_y").html($(this).css("top"));
                            $(this).children(".p_w").html($(this).css("width"));
                            $(this).children(".p_h").html($(this).css("height"));
                            var id = $(this).attr("data-id");
                            var title = $(this).attr("data-title");
                            var x = parseInt($(this).css("left"));
                            var y = parseInt($(this).css("top"));
                            var w = parseInt($(this).css("width"));
                            var h = parseInt($(this).css("height"));
                            $("#area-"+id).val(x+":"+y+":"+w+":"+h+":"+title);
                        }
                    });
                }
            });
        </script>