<?php
$config = ModuleLoader::getConfig("epaper");
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
?> 
<script src="<?php echo AssetsManager::i()->getCoreAsset("js/plupload/plupload.full.min.js") ?>"></script>
<div class="btn-toolbar">
    <a class="btn btn-primary" href="<?= $this->createUrl("//epaper/admin/edition/index") ?>">
        <span class="glyphicon glyphicon-backward"></span>
        Back to Edition List</a>
</div>
<div id="tabs">
    <ul>
        <li><a href="#tabs-1">JPG Upload</a></li>
        <?php if (EpaperSettings::i()->enable_pdf2jpg) { ?> 
            <li><a href="#tabs-2">Extract from PDF</a></li>     
        <?php } ?>
    </ul>
    <div id="tabs-1">
        <p>
            Note: File must be in jpg, png or gif format. Maximum file size is <?php echo ini_get('upload_max_filesize'); ?>
        </p>
        <div id="container">
            <div class="row">        
                <div class="form-group col-xs-6">
                    <p>
                        <label for="sp_id">Supplementary</label>
                        <?php echo CHtml::dropDownList("sp_id", "0", EpaperSupp::getAssoList(), array("class" => "form-control")) ?>
                    </p> 
                    <input type="hidden" name="mode" value="filename" /> 
                    <p>
                        <a id="browse" class="btn btn-success" href="javascript:;">[Browse...]</a>
                        <a id="start-upload" class="btn btn-primary" href="javascript:;">Start Upload</a>
                    </p>
                </div>

            </div>
        </div>
    </div>
    <?php if (EpaperSettings::i()->enable_pdf2jpg) { ?> 
        <div id="tabs-2">
            <form method="post" enctype="multipart/form-data" title="Upload &amp; Extract Pdf" id="formExtractPdf">
                <p>
                    Please do not upload large PDF files. This may increase the load on your server or display errors.
                </p>
                
                
                <div id="container">
                    <div class="row">
                        <div class="col-xs-3">
                            <p>
                                <label for="sp_id">Supplementary</label>
                                <?php echo CHtml::dropDownList("sp_id", "0", EpaperSupp::getAssoList(), array("class" => "form-control")) ?>
                            </p>
                        </div>    
                        <div class="col-xs-3">
                            <p>
                                <label for="file">Upload PDF File</label>
                                <input type="file" name="file[]" multiple="multiple" id="file" class="form-control" />
                            </p>
                        </div>
                        <div class="col-xs-2">
                            <p>                                
                                <input type="checkbox" name="antialias" value="1" checked="checked" /> 
                                <label for="antialias">Anti Aliasing</label>
                            </p>
                        </div>
                        <div class="col-xs-2">
                            <p>                                
                                <input type="checkbox" name="alpha" value="1" checked="checked" /> 
                                <label for="alpha">Alpha Flatten</label>
                            </p>
                        </div>
                        <div class="col-xs-2">
                            <p>                                
                                <input type="checkbox" name="sup_sample" value="1"  /> 
                                <label for="sup_sample">Supersampling</label>
                            </p>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-xs-3">
                            <p>
                                <label for="zoom">Density</label>
                                <input type="text" name="zoom" id="zoom" class="form-control" placeholder="%" value="100" />
                            </p>
                        </div>
                        <div class="col-xs-3">
                            <p>
                                <label for="compression">Compression Level(%)</label>
                                <input type="text" name="compression" id="compression" class="form-control" placeholder="%" value="80" />
                            </p>
                        </div>

                        <div class="col-xs-3">
                            <p>
                                <label for="from">From Page</label>
                                <input type="text" name="from" id="from" class="form-control" placeholder="E.g. 1" value="1" />
                            </p>
                        </div>
                        <div class="col-xs-3">
                            <p>
                                <label for="to">To Page</label>
                                <input type="text" name="to" id="to" class="form-control" placeholder="E.g. 2" value="2" />
                            </p>
                        </div>   
                    </div>
                </div>
 
                <p>
                    <button name="btnSubmit" class="btn btn-primary">Upload</button>
                </p>
                <div class="alert alert-info">
                    
                    <ul>
                        <li>Image Magic Extension and GhostScript is required to convert PDF to JPG</li>
                        <li>The output of this feature depends upon the server configuration</li>
                        <li>If Anti Alising does not gives you desired output then disable it and enable Supersampling</li>
                        <li>Supersampling may take longer to process</li>
                    </ul>
                </div>

            </form>



        </div>   
    <?php } ?>
</div>



<ul class="well well-sm" id="filelist"></ul>

<pre id="console" class="well well-sm"></pre>
<button class="btn btn-xs btn-info" type="button" name="btnRefresh" id="btnRefresh">Clear</button>



<script>

    jQuery("#btnExtractPdf").on("click", function () {
<?php if (extension_loaded("imagick")) { ?>
            jQuery("#formExtractPdf").dialog("open");
<?php } else { ?>
            alert("Imagick Extension is required to use this feature.");
<?php } ?>
    });

    jQuery("#btnRefresh, #filelist, #console").hide();
    jQuery("#btnRefresh").on("click", function () {
        jQuery("#filelist, #console, #btnRefresh").hide("slow");
        jQuery("#filelist, #console").html("");

    });
    var uploader = new plupload.Uploader({
        multipart_params: {},
        browse_button: 'browse', // this can be an id of a DOM element or the DOM element itself
        url: '<?php echo $this->createUrl("upload", array("ed_id" => Yii::app()->request->getParam("ed_id", 0))); ?>',
        filters: {
            mime_types: [
                {title: "Image files", extensions: "jpg,gif,png"},
            ],
            max_file_size: <?php echo Helpers::i()->returnBytes(ini_get('upload_max_filesize')); ?>,
        }
    });
    uploader.init();
    uploader.bind('FilesAdded', function (up, files) {
        $("#filelist").show("slow");
        var html = '';
        plupload.each(files, function (file) {
            html += '<li id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></li>';
        });
        document.getElementById('filelist').innerHTML += html;
    });
    uploader.bind('UploadProgress', function (up, file) {
        document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
    });
    uploader.bind('Error', function (up, err) {

        $("#console, #btnRefresh").show();
        document.getElementById('console').innerHTML += "Error #" + err.code + ": " + err.message + " - '" + err.file.name + "'\n";


    });
    uploader.bind('UploadComplete', function (obj) {
        jQuery("#btnRefresh").show("slow");
        loadList();
    });
    uploader.bind("FileUploaded", function (up, file, info) {
        var r = jQuery.parseJSON(info.response);
        if (serverValidation(r)) {
            if (r.status === false) {
                alert("Error while uploading file");
            }
        }
    });
    document.getElementById('start-upload').onclick = function () {
        uploader.settings.multipart_params["mode"] = $("#mode").val();
        uploader.settings.multipart_params["sp_id"] = $("#tabs-1 #sp_id").val();
        uploader.start();
    };
</script>

<div id="listdata" class="listdata">

</div>


<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="clearfix">
    <div class="col-xs-4">
        <div class="form-group imagepreview">
            <a href="#">
                <img src="" class="thumbnail" alt="#" />
            </a>
        </div>
    </div>
    <div class="col-xs-4">        
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'title'); ?>
            <?php echo $form->textField($formModel, 'title', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'title'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'description'); ?>
            <?php echo $form->textArea($formModel, 'description', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'description'); ?>
        </div>  
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'pdf_file'); ?>
            <?php echo $form->fileField($formModel, 'pdf_file', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'pdf_file'); ?>
        </div>
        <div class="form-group is_pdf">

            <a href="" class="btn btn-danger btn-xs">Download PDF</a>

            <?php echo $form->labelEx($formModel, 'delete_pdf'); ?>
            <?php echo $form->checkBox($formModel, 'delete_pdf'); ?>
            <?php echo $form->error($formModel, 'delete_pdf'); ?>
        </div>
    </div>
    <div class="col-xs-4">
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'sp_id'); ?>
            <?php echo $form->dropDownList($formModel, 'sp_id', EpaperSupp::getAssoList(), array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'sp_id'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'meta_description'); ?>
            <?php echo $form->textArea($formModel, 'meta_description', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'meta_description'); ?>
        </div> 
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'meta_keywords'); ?>
            <?php echo $form->textArea($formModel, 'meta_keywords', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'meta_keywords'); ?>
        </div>
    </div>
</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'id'); ?>
<?php $this->endWidget(); ?>


<script>
    loadList();
    $("#tabs").tabs();
    //$("#form").dialog({autoOpen: false, width: 800, position: ['center', 'middle'], modal: true});
    $("#form").dialog({autoOpen: false, width: 800, modal: true});
    $("#btnNew").on("click", function () {
        $(".imagepreview a").attr("href", "#");
        $(".imagepreview img").attr("src", "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>");
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");
        resetForm("#form");
    });
    $(document).on("click", ".linkbtn_delete", function (e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if (answer) {
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function (data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList();
                        }
                    }
                }
            });
        }
    });
    $(document).on("click", ".linkbtn_edit", function (e) {
        e.preventDefault();
        var id = $(this).attr("data-id");
        resetForm("#form");
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function (data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        //populateForm("#form", data.data.result, "EpaperPage");
                        $("#form #EpaperPageForm_title").val(data.data.result.pg_title);
                        $("#form #EpaperPageForm_description").val(data.data.result.pg_desc);
                        $("#form #EpaperPageForm_meta_description").val(data.data.result.pg_metadesc);
                        $("#form #EpaperPageForm_meta_keywords").val(data.data.result.pg_metakeys);
                        $("#form #EpaperPageForm_id").val(data.data.result.pg_id);
                        $("#form #EpaperPageForm_sp_id").val(data.data.result.sp_id);
                        $("#form .is_pdf").hide();

                        if ($.trim(data.data.result.pg_pdf) !== "") {
                            $("#form .is_pdf").show();
                            $("#form .is_pdf a").attr("href", "<?php echo Yii::app()->getBaseUrl() . $uploadDir . $mediaDir; ?>" + data.data.result.pg_pdf);
                        }

                        var mdl = data.data.result;
                        if ($.trim(mdl.pg_file) != "") {
                            var imgsrc = "<?php echo Yii::app()->getBaseUrl() . $uploadDir . $mediaDir; ?>" + mdl.pg_file;
                            var thumbsrc = "<?php echo ImageHelpers::i()->getThumbImageSq("T_imgsrc", 200); ?>";
                            thumbsrc = thumbsrc.replace("T_imgsrc", imgsrc);
                        } else {
                            var imgsrc = "#";
                            var thumbsrc = "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>";
                        }
                        $(".imagepreview img").attr("src", thumbsrc);
                        $(".imagepreview a").attr("href", imgsrc);
                        $("#form").dialog("open");
                        $("#form").dialog("option", "title", "Edit");
                    } else {
                        alert("File Not Found");
                    }
                }
            }
        });
    });
    $(document).on("click", ".btnImport", function (e) {
        e.preventDefault();
        var id = $(this).attr("data-id");
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("import"); ?>",
            success: function (data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        loadList();
                    } else {
                        alert("Some Error While Date Import");
                    }
                }
            }
        });
    });

    function submitForm(form, data, hasError) {
        if (!hasError) {
            form.ajaxSubmit({
                type: "post",
                dataType: "json",
                success: function (data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList();
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function (XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }

    function loadList() {
        $.get("<?php echo $this->createUrl("loadlist", array("ed_id" => Yii::app()->request->getParam("ed_id", 0))) ?>", {}, function (response) {
            if (serverValidation(response) === true) {
                $("#listdata").html(response.data.result);
            }

        }, "json");
    }

</script>
