<?php
$config = ModuleLoader::getConfig("epaper");        
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];        
?>
<div id="sortable">
    <?php if(count($models)>0){ foreach($models as $model){ ?>
    <div class="rowbox " id="item-<?php echo $model->pg_id; ?>">
        <div class="row">
         
        <?php 
        $imgfile = Yii::getPathOfAlias("webroot").$uploadDir.$mediaDir.$model->pg_file;
        $img = Yii::app()->getBaseUrl().$uploadDir.$mediaDir.$model->pg_file;
        $thumb = ImageHelpers::i()->getThumbImage($img, 100, 100,true) ?>
        
        <div class="col-xs-2">        
            <a class="thumbnail" data-lightbox="image-<?php echo uniqid() ?>" href="<?php echo $img ?>" target="_blank">
                <img src="<?php echo $thumb ?>" alt="Thumbnail" />
            </a>
        </div>
        <div class="col-xs-10">       
            <p>
            <strong><?php echo CHtml::encode($model->pg_title); ?></strong> <?php if(!is_null($model->rSupp)){  echo "[".$model->rSupp->sp_name."]"; } ?>
            </p> 
            <p>
                <?= CHtml::encode($model->pg_desc) ?>
            </p>
                <?php 
                if(file_exists($imgfile)){
                $size = filesize($imgfile); 
                } else {
                    $size = 0;
                }
            
            if($size <= 1024){
                $size = $size." bytes";
            } else if($size>1024 && $size<=1048576){
                $size = number_format(($size/1024), 2, ".", "")." KB";
            } else if($size>1048576){
                $size = number_format(($size/1048576), 2, ".", "")." MB";
            }
            
       
            ?> 
            <p>
            <?php $icon = '<i class="glyphicon glyphicon-pencil color-white"></i> Create Area Maps';
                echo CHtml::link($icon, $this->createUrl("admin/map/index",array("id"=>$model->pg_id)), 
                     array("data-id" => $model->pg_id, "target"=>"_blank", "class" => "linkbtn_view btn btn-primary btn-xs")); ?>                
                <?php echo AdminHelpers::i()->linkbtnEdit($model->pg_id); ?>
                <?php echo AdminHelpers::i()->linkbtnDelete($model->pg_id); ?>         
                <?php
                if(trim($model->pg_cdata)!=""){                
                    echo CHtml::link("Import Maps", "#", array("data-id" => $model->pg_id, "class" =>"btnImport btn btn-default btn-xs"));
                }
                ?>
                <span class="label label-default"><?= $size ?></span>
                
            </p>
        </div>
        </div>
    </div>
    <?php } } ?>    
</div>

<script>
$(function() {
    $( "#sortable" ).sortable({
        axis: 'y',
        update: function (event, ui) {
            var data = $(this).sortable('serialize');
       
            // POST to server using $.post or $.ajax
            $.ajax({
                data: data+"&ed_id=<?php echo Yii::app()->request->getParam("ed_id",0) ?>",
                type: 'POST',
                url: '<?php echo $this->createUrl("saveorder") ?>'
            });
        }
    });
    $( "#sortable" ).disableSelection(); 
});
</script>