<p>
    <button name='btnNew' class='btn btn-primary' id='btnNew'>Schedule New Edition</button>    
</p>
<p>
    Please note that the editions will get published according to the server time. Current server time is <?php echo date("d-M-Y H:i:s") ?>
</p>

 

<table class='table'>
    <thead>
        <tr>
            <th class='col-xs-2'>Actions</th>
            <th>Edition</th>
            <th>Time</th>
        </tr>
    </thead>
    <tbody id='tbodyList'>
        
    </tbody>
</table>
 
<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
 
<p>Find edition to publish</p>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'edition_id'); ?>
            <?php echo CHtml::textField("edition","",array("class"=>"form-control","placeholder"=>"Find editions")); ?>             
            <?php echo $form->hiddenField($formModel, 'edition_id', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'edition_id'); ?>
        </div>
<p>Choose date and time</p>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'date'); ?>
            <?php echo $form->textField($formModel, 'date', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'date'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'time'); ?>
            <?php echo $form->textField($formModel, 'time', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'time'); ?>
        </div>  
<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'id'); ?>
<?php $this->endWidget(); ?>


<script>
function loadList(){
    $.ajax({
        "url":"<?php echo $this->createUrl("loadlist") ?>",
        "dataType":"html",
        "type":"post",
        "success":function(response){
            $("#tbodyList").html(response);
        }
    });
}    
loadList();
//$("#form").dialog({autoOpen: false, width: 300, position: ['center', 'middle'], modal: true});
    $("#form").dialog({autoOpen: false, width: 300,   modal: true});
    
    $("#btnNew").on("click", function() {         
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");  
        $("#edition").attr('placeholder','Find editions');
        resetForm("#form");         
    });
    $('#EpaperSchedulerForm_time').timepicker({
        timeFormat: "HH:mm:ss"
    });
    $("#EpaperSchedulerForm_date").datepicker({
        dateFormat: "dd M yy",
        changeYear: true,
        changeMonth: true,
        yearRange: '1995:2050'
    });
    $( "#edition" ).autocomplete({
        source: "<?php echo $this->createUrl("suggest") ?>",
        minLength: 1,
        select: function( event, ui ) {                
            $(this).val(""); 
            $(this).attr("placeholder",ui.item.value);
            $( "#EpaperSchedulerForm_edition_id" ).val(ui.item.id);  
            return false;
        } 
    });
    
    $(document).on("click", ".linkbtn_delete", function(e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if(answer){
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        loadList();
                    }
                }
            });
        }
    });
    
    $(document).on("click", ".linkbtn_edit", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id");        
        var title = $(this).attr("data-title"); 
        resetForm("#form");
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        populateForm("#form", data.data.result, "EpaperSchedulerForm");
                        $("#edition").attr('placeholder',title);
                        $("#form").dialog("open");
                        $("#form").dialog("option", "title", "Edit");
                    } else {
                        alert("Record Not Found");
                    }
                }
            }
        });
    });
    
    function submitForm(form, data, hasError) {
        
        if (!hasError) {
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                         
                            loadList();
                            $("#selectedEdition").html();
                            $("#EpaperSchedulerForm_id").val("");
                            $("#form").dialog("close");
                         
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
    
</script>