<?php
Yii::app()->clientScript->registerCssFile(AssetsManager::i()->getModuleAsset("epaper", "style.css"));
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
?>
<div class="row">
    <div class="col-xs-8">
        <?php
        $x = 1;
        if (count($edition_models) > 0) {
            ?>
            <div class="clearfix editionlist-block">
                <h1 class="title2 text-center"><?php echo Yii::t("epaper","Featured Editions") ?></h1>
                <?php
                foreach ($edition_models as $model) {
                    $model = $model->rEpaperEdition;
                    if($model->ed_status == "private"){
                        continue;
                    }
                    $imageurl = $epaper_mediadir . $model->ed_image;
                    if (trim($model->ed_image) == "") {
                        $thumb = ImageHelpers::i()->getDefaultImage(193, 250, true);
                    } else {
                        $thumb = ImageHelpers::i()->getThumbImage($imageurl, 193, 250, true);
                    }
                    if ($x == 1) {
                        echo "<div class='row'>";
                    }
                    ?>
                    <section class="col-xs-4 epost">
                        <header class="text-center epost-header">
                            <h1 class="epost-title"><a href="<?php echo $this->createUrl("//epaper/default/show", array("id" => $model->ed_id, "alias" => $model->ed_alias)); ?>"><?php echo CHtml::encode($model->ed_title); ?></a></h1>
                            <time class="epost-date"><?php echo Helpers::i()->formatDate($model->ed_date, "M d, Y") ?></time>
                        </header>
                        <a class="thumbnail epost-image" href="<?php echo $this->createUrl("//epaper/default/show", array("id" => $model->ed_id, "alias" => $model->ed_alias)); ?>">
                            <img src="<?php echo $thumb; ?>" />
                        </a>
                        <div class="epost-category">
                            <a href="<?php echo $this->createUrl("//epaper/default/index", array("id" => $model->rCategory->cat_id, "alias" => $model->rCategory->cat_alias)) ?>">[ <?php echo CHtml::encode($model->rCategory->cat_title); ?> ]</a>
                        </div>
                    </section>
                    <?php
                    if ($x == 3) {
                        $x = 1;
                        echo "</div>";
                    } else {
                        $x++;
                    }
                }

                if ($x != 1) {
                    echo "</div>";
                }
                ?>
            </div>
        <?php } ?>


        <?php if (count($category_models) > 0) { ?>
            <section class="subcategory-block">
                <h1 class="title2 text-center"><?php echo Yii::t("epaper","Featured Categories"); ?></h1>

                <div class="content">

                    <?php
                    $x = 1;
                    foreach ($category_models as $model) {
                        $model = $model->rEpaperCategory;
                        $imageurl = $epaper_mediadir . $model->cat_image;
                        if (trim($model->cat_image) == "") {
                            $thumb = ImageHelpers::i()->getDefaultImage(100, 100, true);
                        } else {
                            $thumb = ImageHelpers::i()->getThumbImage($imageurl, 100, 100, true);
                        }
                        if ($x == 1) {
                            echo "<div class='row'>";
                        }
                        ?>

                        <div class="col-xs-6">
                            <div class="clearfix">
                                <div class="image">
                                    <a class="thumbnail" href="<?php echo $this->createUrl("//epaper/default/index", array("id" => $model->cat_id, "alias" => $model->cat_alias)); ?>">
                                        <img src="<?php echo $thumb; ?>" />
                                    </a>
                                </div>
                                <div class="description">
                                    <h2><?php echo CHtml::link(CHtml::encode($model->cat_title), $this->createUrl("//epaper/default/index", array("id" => $model->cat_id, "alias" => $model->cat_alias))); ?></h2>
                                    <p><?php echo CHtml::encode(Helpers::i()->wordLimiter($model->cat_desc, 17)); ?></p>
                                </div>
                            </div>
                        </div>

                        <?php
                        if ($x == 2) {
                            echo "</div>";
                            $x = 1;
                        } else {
                            $x++;
                        }
                    }
                    if ($x != 1) {
                        echo "</div>";
                    }
                    ?>
                </div>
            </section>

        <?php } ?>






    </div>
    <div class="col-xs-4">
        <?php echo PanelComponent::i()->render("default-panel") ?>
    </div>
</div>

