<?php
Yii::app()->clientScript->registerCssFile(AssetsManager::i()->getModuleAsset("epaper","style.css"));
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
?>
<article>
<header>
    <h1 class="title1"><?php echo CHtml::encode($pagetitle); ?></h1>
</header>
<?php if (count($subcategory_models) > 0) { ?>
    
    <section class="subcategory-block">
        <div class="toggle_title">
            <span class="glyphicon glyphicon-plus"></span> <span class="visible-status"><?php echo Yii::t("epaper","Show"); ?></span> 
                <?php if ($id == 0) { ?>
                <?php echo Yii::t("epaper","All Categories") ?>
            <?php } else { ?>
                <?php echo Yii::t("epaper","Subcategories") ?>
            <?php } ?>
        </div>

        <div class="content">
            
        <?php
        $x = 1;
        foreach ($subcategory_models as $model) {
            $imageurl = $epaper_mediadir . $model->cat_image;
            if (trim($model->cat_image) == "") {
                $thumb = ImageHelpers::i()->getDefaultImage(100, 100, true);
            } else {
                $thumb = ImageHelpers::i()->getThumbImage($imageurl, 100, 100, true);
            }
            if ($x == 1) {
                echo "<div class='row'>";
            }
            ?>

            <div class="col-xs-4">
                <div class="clearfix">
                    <div class="image">
                        <a class="thumbnail" href="<?php echo $this->createUrl("//epaper/default/index", array("id" => $model->cat_id,"alias"=>$model->cat_alias)); ?>">
                            <img src="<?php echo $thumb; ?>" />
                        </a>
                    </div>
                    <div class="description">
                        <h2><?php echo CHtml::link(CHtml::encode($model->cat_title), $this->createUrl("//epaper/default/index", array("id" => $model->cat_id,"alias"=>$model->cat_alias))); ?></h2>
                        <p><?php echo CHtml::encode(Helpers::i()->wordLimiter($model->cat_desc, 17)); ?></p>
                    </div>
                </div>
            </div>

            <?php
            if ($x == 3) {
                echo "</div>";
                $x = 1;
            } else {
                $x++;
            }
        }
        if ($x != 3) {
            echo "</div>";
        }
        ?>
        </div>
            
    </section>
<script>
    var content_visible = false;
    $(".subcategory-block .content").hide();
    $(".subcategory-block .toggle_title").on("click",function(e){
    
        if(content_visible==false){
            $(".subcategory-block .content").show("slow");      
            $(".subcategory-block .glyphicon").removeClass("glyphicon-plus").addClass("glyphicon-minus");
            $(".visible-status").text("<?php echo Yii::t("epaper","Hide") ?>");
            content_visible = true;
        } else {
            $(".subcategory-block .content").hide("slow");        
            $(".subcategory-block .glyphicon").addClass("glyphicon-plus").removeClass("glyphicon-minus");
            $(".visible-status").text("<?php echo Yii::t("epaper","Show") ?>");
            content_visible = false;
        }
    });
    $(document).ready(function(){
        $("select[name=category]").val("<?php echo Yii::app()->request->getParam("id") ?>");
    });
    </script>
<?php } ?>

 

<div class="clearfix editionlist-block">
    <?php
    $x=1;
    foreach ($edition_models as $model) { 
        $imageurl = $epaper_mediadir . $model->ed_image;
        if (trim($model->ed_image) == "") {
            $thumb = ImageHelpers::i()->getDefaultImage(200, 250, true);
        } else {
            $thumb = ImageHelpers::i()->getThumbImage($imageurl, 200, 250, true);
        }
        if($x==1){
            echo "<div class='row'>";
        }
        ?>
        <section class="col-xs-3 epost">
            <header class="text-center epost-header">
                <h1 class="epost-title"><a href="<?php echo $this->createUrl("//epaper/default/show", array("id" => $model->ed_id,"alias"=>$model->ed_alias)); ?>"><?php echo CHtml::encode($model->ed_title); ?></a></h1>
                <time class="epost-date"><?php echo Helpers::i()->formatDate($model->ed_date,"M d, Y") ?></time>
            </header>
            <a class="thumbnail epost-image" href="<?php echo $this->createUrl("//epaper/default/show", array("id" => $model->ed_id,"alias"=>$model->ed_alias)); ?>">
                <img src="<?php echo $thumb; ?>" />
            </a>
            <div class="epost-category">
                <a href="<?php echo $this->createUrl("//epaper/default/index",array("id"=>$model->rCategory->cat_id,"alias"=>$model->rCategory->cat_alias)) ?>">[ <?php echo CHtml::encode($model->rCategory->cat_title); ?> ]</a>
            </div>
        </section>
<?php 
        if($x==4){
            echo "</div>";
            $x = 1;
        } else {
            $x++;
        }

        }
        
        if($x!=1){
            echo "</div>";
        }
        ?>
</div> 
<?php
$this->widget('CLinkPager', array(
    'pages' => $pagination,
    'cssFile' => false,
    'header' => false,
    'hiddenPageCssClass' => 'disabled',
    'selectedPageCssClass' => 'active',
    'htmlOptions' => array("class" => "pagination")
));
?>
    
    </article>
