<?php 
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
$clientScript = Yii::app()->getClientScript();
$clientScript->registerScriptFile(AssetsManager::i()->getModuleAsset("epaper","colorbox/jquery.colorbox-min.js"));
$clientScript->registerCssFile(AssetsManager::i()->getModuleAsset("epaper","colorbox/example3/colorbox.css"));
$clientScript->registerCssFile(AssetsManager::i()->getModuleAsset("epaper","style.css"));
?>
<article class="edition-block">
<header>
    <h1 class="title1"><?php echo CHtml::encode($pagetitle); ?></h1>
</header>
<?php if(trim($edition_model->ed_desc)!=""){ ?>
<div class="description">
    <?php echo Helpers::i()->makeLinksActive(CHtml::encode($edition_model->ed_desc)); ?>
</div>
<?php } ?>

<div class="row">
    <div class="col-xs-2">
        <?php if(trim($edition_model->ed_pdf)!=""){ ?>
        <div class='clearfix'>
            <a class="btn btn-danger col-xs-12" href="<?php echo EpaperHelpers::i()->getPdfLink($edition_model); ?>"><span class='glyphicon glyphicon-file'></span> Full PDF</a>
        </div>
        <?php } ?>
        
        <div class="pagelist-title"><?php echo Yii::t("epaper","Pages"); ?></div>
        <ul class="pagelist">
            <?php
            $params = array("id" => $id, "alias"=>$alias);
            
            if($spid>0){
                $params["spid"] = $spid;
                $params["spalias"] = $spalias;
            }
            
            foreach ($page_models as $k=>$pms) {                
                if($k == $spid){
                    $n = 1;
                    foreach($pms as $pm){
                        $params["page"] = $n;
                        if($n==$page){
                            echo "<li>" . CHtml::link($pm->pg_title, $this->createUrl("//epaper/default/show", $params),array("class"=>'current')) . "</li>";
                        } else {
                            echo "<li>" . CHtml::link($pm->pg_title, $this->createUrl("//epaper/default/show", $params)) . "</li>";
                        }
                        $n++;
                    }                    
                } 
            }
            ?>
        </ul>
    </div>
    <div class="col-xs-10">
        <ul class="nav nav-tabs">
            <?php if(count($page_models)>0){ ?>
                <li <?php if($spid==0){ echo "class='active'"; } ?> role="presentation"><a href="<?php echo $this->createUrl("//epaper/default/show",array("id" => $id, "alias"=>$alias)); ?>">Home</a></li>
                <?php foreach($page_models as $k=>$pgms){ 
                    foreach($supp_list as $r){
                        if($r["sp_id"] == $k){
                            echo '<li'; 
                            
                            if($spid==$k){ echo " class='active' "; }
                            
                            echo ' role="presentation"><a href="'.$this->createUrl("//epaper/default/show",array("id" => $id, "alias"=>$alias,"spid"=>$r["sp_id"],"spalias"=>$r["sp_alias"])).'">'.$r["sp_name"].'</a></li>';
                        }
                    }
                } ?>
            <?php } ?>
        </ul>
        
        <h2 class="title2"><?php 
        if(trim($current_page_model->pg_title)==""){
            echo Yii::t("epaper","Page")." ".$page;
        } else {
            echo CHtml::encode($current_page_model->pg_title); 
        } ?></h2>
    
        <?php if(trim($current_page_model->pg_desc)!=""){ ?>
        <div class="description">
            <?php echo Helpers::i()->makeLinksActive(CHtml::encode($current_page_model->pg_desc)); ?>
        </div>
        <?php } ?>
        
        <?php 
        $imgurl = $epaper_mediadir.$current_page_model->pg_file;
        $thumburl = ImageHelpers::i()->getThumbImage($imgurl, 760);
        $imgtag = CHtml::image($thumburl);                   
        $this->widget('EpaperPageWidget', array(
            'pageModel'=>$current_page_model,
            'containerWidth'=>770
        ));
        ?>
        
        <?php if(trim($current_page_model->pg_pdf)!=""){ ?>
        <div class='clearfix text-center well'>
            <a class="btn btn-danger" href="<?php echo EpaperHelpers::i()->getPdfLink($current_page_model); ?>"><span class='glyphicon glyphicon-file'></span> Download Current Page PDF</a>
        </div>
        <?php } ?>
        
    </div>
     
</div>
    </article>

<script>
   
$('.imagethumb').colorbox();   
$(document).on("click",".cboxPhoto",function(){
    $.colorbox.close() 
}); 
</script>

<script type="text/javascript">var switchTo5x=true;</script>
<script type="text/javascript" src="http://w.sharethis.com/button/buttons.js"></script>
<script type="text/javascript">stLight.options({publisher: "ur-c19bdb29-d703-ab69-7562-95015e1bf501", doNotHash: true, doNotCopy: true, hashAddressBar: false});</script>