<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class DefaultController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("md_manage_media");
        
    }
    public function actionIndex(){
        $this->pageTitle = "Media Manager";
        $this->render("index",array("formModel"=>new Media()));
    }
    public function actionUpload(){ 
        $config = ModuleLoader::getConfig("media");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $pg_image = "";
        $imagefile = CUploadedFile::getInstanceByName("file");  
         
        $title = uniqid();
        if(!is_null($imagefile)){
            $ext = $imagefile->getExtensionName();
            $title = substr($imagefile->getName(),0,-4);       
            $filename = MediaManager::i()->upload($imagefile);
        } else {
            AjaxOutput::i()->setError("Please select a file to upload")->display();
        }
        
        $model = new Media();
        $model->md_title=  $title;        
        $model->md_file = $filename;        
        if($model->validate()){
            $model->save();
            AjaxOutput::i()->setStatus(true)->display();
        } else {
            AjaxOutput::i()
                ->setStatus(false)
                ->setValidationStatus(false)
                ->setValidationErrors($model->getErrors())
                ->display(); 
        }
    }
    public function actionLoadlist(){
        $config = ModuleLoader::getConfig("media");
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];

        $page = Yii::app()->request->getParam("page",1);
        $search = Yii::app()->request->getParam("search","");
        $offset = ($this->perpage * $page) - $this->perpage;
        
        $data = Media::loadList($search,$this->perpage,$offset);
        $newrecords = array();
        
        foreach($data["records"] as $r){
            $ext = strtolower(pathinfo($r["md_file"],PATHINFO_EXTENSION));
            $url = Yii::app()->getBaseUrl(true).$uploadDir.$mediaDir.$r["md_file"];
            $newdata = $r;
            if($ext == "jpg" || $ext == "jpeg" || $ext == "png" || $ext == "gif"){ 
                $newdata["thumb"] = ImageHelpers::i()->getThumbImage($url, 250, 250, true);
            } else {
                $icon = AssetsManager::i()->getModuleAsset("media", "icons/$ext.png");
                $iconfile = Yii::getPathOfAlias("application.modules.media.assets.icons")."/".$ext.".png";
                if(!file_exists($iconfile)){
                    $newdata["thumb"] = ImageHelpers::i()->getDefaultImageSq(250);
                } else {
                    $newdata["thumb"] = ImageHelpers::i()->getThumbImage($icon, 250, 250, true);
                }
            }
            $newdata["title"] = Helpers::i()->characterLimiter($r["md_title"],20,"...");
            $newdata["ext"] = $ext;
            $newdata["url"] = $url;
            $newrecords[] = $newdata;
        }
        
        $d = array("records"=>$newrecords,"total"=>$data["total"]);
        
        AjaxOutput::i()->setData($d)->display();
        
    }
    public function actionGet(){
        $id = Yii::app()->request->getParam("id");
        $model = Media::model()->findByPk($id);
        AjaxOutput::i()->setData($model)->display();
    }
    public function actionSave(){
        $params = Yii::app()->request->getParam("Media");
        $model = Media::model()->findByPk($params["md_id"]);
        if(!is_null($model)){
            $model->md_title = $params["md_title"];
            if($model->validate()){
                $model->save();
                AjaxOutput::i()->setStatus(true)->display();
            }
        }
        AjaxOutput::i()->setStatus(false)->display();
    }
    public function actionDelete(){
        $config = ModuleLoader::getConfig("media");                
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $id = Yii::app()->request->getParam("id");
        $model = Media::model()->findByPk($id);
        if(!is_null($model)){
            MediaManager::i()->delete($model->md_file);
            $model->delete();
            AjaxOutput::i()->setStatus(true)->display();
        }
        AjaxOutput::i()->setStatus(false)->display();
    }
}