<?php

/**
 * This is the model class for table "media".
 *
 * The followings are the available columns in table 'media':
 * @property string $md_id
 * @property string $md_title
 * @property string $md_file
 */
class Media extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'media';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('md_title, md_file', 'required'),
			array('md_title, md_file', 'length', 'max'=>255),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('md_id, md_title, md_file', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'md_id' => 'Id',
			'md_title' => 'Title',
			'md_file' => 'File',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('md_id',$this->md_id,true);
		$criteria->compare('md_title',$this->md_title,true);
		$criteria->compare('md_file',$this->md_file,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Media the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        public static function loadList($search="",$perpage=10,$offset){
            $conditions = "md_title LIKE :search";
            $params[":search"] = "%$search%";
            
            $data["records"] = Yii::app()->db->createCommand()->select("*")->from(Media::model()->tableName())
                    ->where($conditions, $params)->order("md_id DESC")->limit($perpage, $offset)->queryAll();
            
        
            
            $data["total"] = Yii::app()->db->createCommand()->select("COUNT(*)")->from(Media::model()->tableName())
                    ->where($conditions, $params)
                    ->order("md_id DESC")->queryScalar();
            
            return $data;
        }
}
