<?php
$config = ModuleLoader::getConfig("media");        
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];        
?> 
<script src="<?php echo AssetsManager::i()->getCoreAsset("js/plupload/plupload.full.min.js") ?>"></script>

<p>
    Note: File must be in jpg, png or gif format. Maximum file size is <?php echo ini_get('upload_max_filesize'); ?>
</p>

 
<div class="row">
    <div class="col-xs-3">
        <div id="container">         
            <a id="browse" class="btn btn-default" href="javascript:;">[Browse...]</a>
            <a id="start-upload" class="btn btn-primary" href="javascript:;">Start Upload</a>        
        </div>
    </div>
    <div class="col-xs-5">
    </div>
    <div class="col-xs-4">         
         <div class="input-group">             
            <input type="text"  class="form-control" placeholder="Search..." name="search" id="search" value="" />
            <span class="input-group-btn">
                <button name="btnGo" id="btnGo" class="btn btn-primary">Go</button>
                <button name="btnReset" id="btnReset" class="btn btn-default">Reset</button>
            </span>
        </div>
    </div>
</div>

<div class="pager" id="pager"></div>        

<ul class="well well-sm" id="filelist"></ul>
 
<pre id="console" class="well well-sm"></pre>
<button class="btn btn-xs btn-info" type="button" name="btnRefresh" id="btnRefresh">Clear</button>


<script>
    jQuery("#btnRefresh, #filelist, #console").hide();
    jQuery("#btnRefresh").on("click",function(){
        jQuery("#filelist, #console, #btnRefresh").hide("slow");
        jQuery("#filelist, #console").html("");
         
    });
    var uploader = new plupload.Uploader({
      multipart_params: {},
      browse_button: 'browse', // this can be an id of a DOM element or the DOM element itself
      url: '<?php echo $this->createUrl("upload"); ?>',
      filters: { 
            max_file_size: <?php echo Helpers::i()->returnBytes(ini_get('upload_max_filesize')); ?>,
        }
    });
    uploader.init(); 
    uploader.bind('FilesAdded', function(up, files) {
      $("#filelist").show("slow");
      var html = '';
      plupload.each(files, function(file) {
        html += '<li id="' + file.id + '">' + file.name + ' (' + plupload.formatSize(file.size) + ') <b></b></li>';
      });
      document.getElementById('filelist').innerHTML += html;
    }); 
    uploader.bind('UploadProgress', function(up, file) {
      document.getElementById(file.id).getElementsByTagName('b')[0].innerHTML = '<span>' + file.percent + "%</span>";
    }); 
    uploader.bind('Error', function(up, err) {
         
        $("#console, #btnRefresh").show();  
        document.getElementById('console').innerHTML += "Error #" + err.code + ": " + err.message + " - '" + err.file.name + "'\n";
        
        
    }); 
    uploader.bind('UploadComplete', function(obj) {
        jQuery("#btnRefresh").show("slow");
        loadList(1);
    });
    uploader.bind("FileUploaded",function(up, file, info){   
        var r = jQuery.parseJSON(info.response);
        if(serverValidation(r)){
            if(r.status===false){
                alert("Error while uploading file");
            }
        }
    });
    document.getElementById('start-upload').onclick = function() {      
      uploader.start();
    };
</script>

<div id="listdata" class="listdata clearfix">

</div>


<!-- Templates -->
<p style="display:none">
    <textarea id="templateList" rows="0" cols="0">
<!--      
    {#foreach $T.records as r}
        <div class="col-xs-3">

        <div class="well well-sm">
<p>
            <a  data-lightbox="image-{$T.r.md_id}" target="_blank" href="{$T.r.url}">
            <img class="thumbnail" src="{$T.r.thumb}" />
            </a>
</p>
            <p><strong><a target="_blank" href="{$T.r.url}">{$T.r.title}</a></strong></p>
            <p>{$T.r.ext} File<p>
            <p>
                <?php echo AdminHelpers::i()->linkbtnDelete('{$T.r.md_id}'); ?>
                <?php echo AdminHelpers::i()->linkbtnEdit('{$T.r.md_id}'); ?> 
            </p>
            </div>
        </div>
    {#/for}
-->
    </textarea>
</p>
<!-- //Templates -->

<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="clearfix">
     
        <div class="form-group imagepreview">
            <a href="#">
                <img src="" class="thumbnail" alt="#" />
            </a>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'md_title'); ?>
            <?php echo $form->textField($formModel, 'md_title', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'md_title'); ?>
        </div>
     
 
</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'md_id'); ?>
<?php $this->endWidget(); ?>


<script>
     
    //$("#form").dialog({autoOpen:  false , width: 250, position: ['center', 'middle'], modal: true});
    $("#form").dialog({autoOpen:  false , width: 250,  modal: true});
    
    $("#btnNew").on("click", function() {
        $(".imagepreview a").attr("href","#");
        $(".imagepreview img").attr("src", "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>");        
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");        
        resetForm("#form");
    });
    $(document).on("click", ".linkbtn_delete", function(e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if(answer){
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(1);
                        }
                    }
                }
            });
        }
    });
    $(document).on("click", ".linkbtn_edit", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id"); 
        resetForm("#form");
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    $("#form #Media_md_title").val(data.data.result.md_title);                                      
                    $("#form #Media_md_id").val(data.data.result.md_id);

                    var mdl = data.data.result;
                    if ($.trim(mdl.md_file) != "") {
                        var imgsrc = "<?php echo Yii::app()->getBaseUrl() . $uploadDir.$mediaDir; ?>" + mdl.md_file;
                        var thumbsrc = "<?php echo ImageHelpers::i()->getThumbImageSq("T_imgsrc", 200); ?>";
                        thumbsrc = thumbsrc.replace("T_imgsrc", imgsrc);                           
                    } else {
                        var imgsrc = "#";
                        var thumbsrc = "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>";                            
                    } 
                    $(".imagepreview img").attr("src", thumbsrc);
                    $(".imagepreview a").attr("href", imgsrc);
                    $("#form").dialog("open");
                    $("#form").dialog("option", "title", "Edit");
                     
                }
            }
        });
    });
    
    $("#btnGo").on("click",function(){
        loadList(1);
    });
    $("#btnReset").on("click",function(){
        $("#search").val("");
        loadList(1);
    });
    
    function submitForm(form, data, hasError) {        
        if (!hasError) {
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
    
    var page = 1;
    var total = 0;
    var perpage = <?php echo $this->perpage ?>;
    
    loadList(1);
    
    function getPageCount() {
        if (total > 0) {
            return Math.ceil(total /perpage);
        }
        return 0;
    }
    
    function pageClick(pageclickednumber) {
        $("#pager").pager({pagenumber: pageclickednumber, pagecount: getPageCount(), buttonClickCallback: pageClick});
        loadList(pageclickednumber);
    }
    
    function loadList(cpage){
        var search = $("#search").val();
       
        $.ajax({
            data: {"page": cpage, "search": search },
            url: "<?php echo $this->createUrl("loadlist"); ?>",
            success: function(response, textStatus, XMLHttpRequest) {
                if (serverValidation(response) == true) {                    
                    $("#listdata").setTemplateElement("templateList").processTemplate(response.data.result);
                    
                    
                }
                total = response.data.result.total;       
                
                page = cpage;
                if (page === 1) {
                    $("#pager").pager({pagenumber: page, pagecount: getPageCount(), buttonClickCallback: pageClick});
                }
            }
        });
    }
     
</script>
