<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PageLoader extends AbstractModuleLoader{
    public static function getMenuitems(){
        return array(
          "Page"
        );
    }
            
    public static function getImports(){
        return array(       
            'page.components.*',	
			'page.models.*',			 
                        'page.nplugins.menuitems.*',			 
		);
    }
    
    public static function init(){
        $tasks = array(
          "pg_manage_pages",          
          "pg_generate_sitemap"
        );
        TaskComponent::i()->addTask("Pages",$tasks[0],"Manage Pages");
        TaskComponent::i()->addTask("Pages",$tasks[1],"Generate Sitemap");
        
        AdminMenu::i()->addMenuItem("page","Pages","#",$tasks);        
        AdminMenu::i()->addSubMenuItem("page", "manage_pages", "Pages", Yii::app()->createUrl("//page/admin/default/index"),$tasks[0]);
        AdminMenu::i()->addSubMenuItem("page", "manage_sitemap", "Sitemap", Yii::app()->createUrl("//page/admin/default/sitemap"),$tasks[1]);
    }
  
    public static function getUrlRewritingRules(){
        $routing = parent::getUrlRewritingRules(); 
        $routing['rules']['page/<id>/<alias>'] = 'page/default/index';
        return $routing;
    }

}