<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class DefaultController extends PublicController
{
    public function filters()
    {
        return array(            
            array(
                'COutputCache',
                'duration'=>  BasicSettings::i()->cache_duration,
                'varyByParam'=>array("id","alias"),
            ),
        );
    }
	public function actionIndex()
	{
            $id = Yii::app()->request->getParam("id");
            $alias = Yii::app()->request->getParam("alias", "");
            
            $model = Page::model()->find("page_id = :page_id AND page_status='public'", array(":page_id" => $id));
            if(is_null($model)){
               throw new CHttpException("404", Yii::t("epaper","Page Not Found")); 
            } else {
               if($model->page_alias!=$alias){
                   $this->redirect($this->createUrl("index", array("id" => $id, "alias" => $model->page_alias)), true, 301);
               }
            }
            HeadComponent::i()->addTitle($model->page_title)->addMetaKeywords($model->page_metakeys);
             
            if(trim($model->page_metadesc)!=""){
                HeadComponent::i()->setMetaDescription($model->page_metadesc);                
            } else {
                HeadComponent::i()->setMetaDescription(Helpers::i()->wordLimiter(strip_tags($model->page_content), 30, "..."));           
            }
            $this->breadcrumbs[$model->page_title] = false;
            $this->render("index", array("page_content"=>$model));            
	}
        
         
}