<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class DefaultController extends AdminController{
	public function actionIndex(){
            TaskComponent::i()->permissionGate("pg_manage_pages");
		$cri = new CDbCriteria();
		$cri->order = "page_id desc";
		
		$pages = new CPagination(Page::model()->count($cri));
		$pages->pageSize = $this->perpage;
		$pages->applyLimit($cri);
		
		$data["pages"] = $pages;
		$data["models"] = Page::model()->findAll($cri);
		$this->pageTitle = "Page Management";
		$this->render("index",$data);
	}
	public function actionCreate(){
            TaskComponent::i()->permissionGate("pg_manage_pages");
		$model = new Page();
			
		$data["model"] = $model;
	  
		if(isset($_POST['Page'])){
			$model->attributes=$_POST['Page'];
			  
			if(trim($model->page_alias)==""){
				$alias_tags = Helpers::i()->extractTags($model->page_title);
				$model->page_alias = implode("-", $alias_tags);
			} else {
				$words_to_filter = "~ ! @ # $ % ^ & * ( ) _ + ` = { } | [ ] \ : ; ' < > ? , . /";
				$words_to_filter = explode(" ",$words_to_filter);
				$alias_tags = strtolower($model->page_alias);
				$alias_tags = str_replace($words_to_filter, "-",$alias_tags);
				$alias_tags = str_replace(" ", "-",$alias_tags);
				$model->page_alias = $alias_tags;
			}
			
			if($model->validate()){
				if($model->save()){
					$this->redirect(array('index'));
				}
			}
		}
		$this->pageTitle = "New Page";
		$this->render("form",$data);
	}
	public function actionEdit(){
            TaskComponent::i()->permissionGate("pg_manage_pages");
		$id = Yii::app()->request->getParam("id");
		$model = Page::model()->find("page_id = :page_id",array(":page_id"=>$id));
		if(is_null($model)){
			throw new CHttpException("404", "Page Not Found!");		
		}
		
		$data["model"] = $model;
		if(isset($_POST['Page'])){
			$model->attributes=$_POST['Page'];
			if(trim($model->page_alias)==""){
				$alias_tags = Helpers::i()->extractTags($model->page_title);
				$model->page_alias = implode("-", $alias_tags);
			} else {
				$words_to_filter = "~ ! @ # $ % ^ & * ( ) _ + ` = { } | [ ] \ : ; ' < > ? , . /";
				$words_to_filter = explode(" ",$words_to_filter);
				$alias_tags = strtolower($model->page_alias);
				$alias_tags = str_replace($words_to_filter, "-",$alias_tags);
				$alias_tags = str_replace(" ", "-",$alias_tags);
				$model->page_alias = $alias_tags;
			}
				
			if($model->save()){
				$this->redirect(array('index'));
			}
		}
		$this->pageTitle = "Edit Page";
		$this->render("form",$data);
	}
	public function actionDelete(){	
            TaskComponent::i()->permissionGate("pg_manage_pages");
		$id = Yii::app()->request->getParam("id");
		//Delete Content...
		$model = Page::model()->findByPk($id);
		if($model!=null){
			$model->delete();
			AjaxOutput::i()->setStatus(true);
		}
		AjaxOutput::i()->display();
	}
        public function actionSitemap(){  
            TaskComponent::i()->permissionGate("pg_generate_sitemap");
            $this->pageTitle = "Page Sitemap Generator";
            $this->render("sitemap");
        }
        public function actionDelete_sitemap(){
            TaskComponent::i()->permissionGate("pg_generate_sitemap");
            $sitemapDir = Yii::app()->params["sitemapDir"];        
            $baseDir = Yii::getPathOfAlias("webroot");
            if(file_exists($baseDir.$sitemapDir."page.xml")){
                unlink($baseDir.$sitemapDir."page.xml");
            }
            AjaxOutput::i()->display();
        }
        public function actionGetSitemapForm(){
            TaskComponent::i()->permissionGate("pg_generate_sitemap");
            $form = new PageSitemapSettings();  
            if($_SERVER["REQUEST_METHOD"]=="POST"){
                $form->setAttributes(Yii::app()->request->getParam("PageSitemapSettings"));
                if($form->validate()){
                    $form->saveForm(); 
                    $gen = new SitemapGenerator();
                    $pages = $_POST["PageSitemapSettings"]["included_pages"];
                    $frequency = $_POST["PageSitemapSettings"]["frequency"];
                    $priority = $_POST["PageSitemapSettings"]["priority"];
                    if(is_array($pages)){
                        if(count($pages)>0){
                            foreach($pages as $id){
                                $model = Page::model()->findByPk($id);
                                if(!is_null($model)){
                                    $location = $this->createAbsoluteUrl("//page/default/index",array("id"=>$id,"alias"=>$model->page_alias));
                                    $gen->addItem($location, $location, $frequency, $priority);
                                }
                            }
                        }
                    }
                    
                    $sitemap_data = $gen->generateSitemap();
                    SitemapGenerator::make();
                    if(trim($sitemap_data)!=""){
                        $sitemapDir = Yii::app()->params["sitemapDir"];        
                        $baseDir = Yii::getPathOfAlias("webroot");                 
                        file_put_contents($baseDir.$sitemapDir."page.xml", $sitemap_data);                    
                    }
                    $this->redirect($this->createUrl("getSitemapForm"));                    
                }
            }
            
            ob_start();
            $form->displayForm($this->createUrl("getSitemapForm"),"Save and Generate");
            $data = ob_get_contents();
            ob_clean();
            
            AjaxOutput::i()->setData($data)->display();
        }
}