<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "pages".
 *
 * The followings are the available columns in table 'pages':
 * @property integer $page_id
 * @property string $page_title
 * @property string $page_alias
 * @property string $page_content
 * @property string $page_status
 */
class Page extends CActiveRecord {

    /**
     * Returns the static model of the specified AR class.
     * @param string $className active record class name.
     * @return Page the static model class
     */
    public static function model($className = __CLASS__) {
        return parent::model($className);
    }

    /**
     * @return string the associated database table name
     */
    public function tableName() {
        return 'pages';
    }

    /**
     * @return array validation rules for model attributes.
     */
    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('page_title, page_status', 'required'),
            array('page_alias, page_content', 'length', 'allowEmpty' => true),
            array('page_title, page_alias', 'length', 'max' => 255),
            array('page_metadesc, page_metakeys', 'length', 'max' => 1000),
            // The following rule is used by search().
            // Please remove those attributes that should not be searched.
            array('page_id, page_title, page_alias, page_content, page_status', 'safe', 'on' => 'search'),
        );
    }

    /**
     * @return array relational rules.
     */
    public function relations() {
        // NOTE: you may need to adjust the relation name and the related
        // class name for the relations automatically generated below.
        return array(
        );
    }

    /**
     * @return array customized attribute labels (name=>label)
     */
    public function attributeLabels() {
        return array(
            'page_id' => 'Page Id',
            'page_title' => 'Title',
            'page_alias' => 'Alias',
            'page_content' => 'Content',
            'page_status' => 'Status',
            'page_metadesc' => 'Meta Description',
            'page_metakeys' => 'Meta Keywords',
        );
    }

    /**
     * Retrieves a list of models based on the current search/filter conditions.
     * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
     */
    public function search() {
        // Warning: Please modify the following code to remove attributes that
        // should not be searched.

        $criteria = new CDbCriteria;

        $criteria->compare('page_id', $this->page_id);
        $criteria->compare('page_title', $this->page_title, true);
        $criteria->compare('page_alias', $this->page_alias, true);
        $criteria->compare('page_content', $this->page_content, true);
        $criteria->compare('page_status', $this->page_status, true);
        $criteria->compare('page_metadesc', $this->page_metadesc, true);
        $criteria->compare('page_metakeys', $this->page_metakeys, true);

        return new CActiveDataProvider($this, array(
            'criteria' => $criteria,
        ));
    }

    /**
     * Checks whether alias and id of page match or not.
     * @param int $id
     * @param string $alias
     * @return boolean
     */
    public function checkAlias($id, $alias) {
        $model = $this->findByPk($id);
        if (is_null($model)) {
            return false;
        } else {
            if ($alias == $model->page_alias) {
                return true;
            } else {
                return $model->page_alias;
            }
        }
    }
    
    function getSpecialPageContent($key){     
        $page_id = Settings::i()->get($key);
        if($page_id>0){
            $model = Page::model()->findByPk($page_id);
            if(!is_null($model)){
                return $model;
            }    
        }
        return false;
    }

}