<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PageMenuitem extends AbstractMenuitem {

    public function adminForm() {
        echo "<div class='form-group'>";
        echo $this->form->label($this, "page_id");
        echo $this->form->dropDownList($this, "page_id", CHtml::listData(Page::model()->findAll(), "page_id", "page_title"),array("class"=>"form-control"));
        echo $this->form->error($this, "page_id");
        echo "</div>";
    }

    public $page_id;

    public function getLink($arg, $data) {
        $page_id = $data["page_id"];
        $model = Page::model()->findByPk($page_id);
        return Yii::app()->createUrl("//page/default/index", array("id" => $model->page_id, "alias" => $model->page_alias));
    }

    public function rules() {
        $rules = parent::rules();
        $rules[] = array("page_id", "required");
        return $rules;
    }

    public function attributeLabels() {
        $labels = parent::attributeLabels();
        $labels["page_id"] = "Page";
        return $labels;
    }

}