<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class PageSitemapSettings extends AbstractAdminSettingsForm{
    
    public $included_pages = "";
    public $frequency = "never";
    public $priority = "0.5";
    
    public function rules() {
        $rules = parent::rules(); 
        $rules[] = array("included_pages","pageVal");
        $rules[] = array("frequency, priority","length", "allowEmpty"=>true);
        return $rules;
    }
    
    public function pageVal(){
        $this->included_pages = serialize($this->included_pages);
    }
    
    public function adminForm() {
        $this->included_pages = unserialize($this->included_pages);
        $pages = CHtml::listData(Page::model()->findAll(),"page_id","page_title");
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "included_pages")."<br />";
        echo $this->form->checkBoxList($this, "included_pages",$pages);
        echo $this->form->error($this, "included_pages");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "priority");
        echo $this->form->textField($this, "priority",array("class"=>"form-control"));
        echo $this->form->error($this, "priority");
        echo CHtml::closeTag("div");
        
        $freqlist = array(
            "always"=>"Always",
            "hourly"=>"Hourly",
            "daily"=>"Daily",
            "weekly"=>"Weekly",
            "monthly"=>"Monthly",
            "yearly"=>"Yearly",
            "never"=>"Never",
            ""=>"[Do not include]"
        );        
         
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "frequency");
        echo $this->form->dropDownList($this,"frequency",$freqlist, array("class"=>"form-control"));
        echo $this->form->error($this, "frequency");
        echo CHtml::closeTag("div");
    }

}