<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'pageForm',
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="row">
    <div class="col-xs-6">
        <div class="form-group">
            <?php echo $form->labelEx($model, 'page_title'); ?>
            <?php echo $form->textField($model, 'page_title', array("class" => "form-control")); ?>
            <?php echo $form->error($model, 'page_title'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($model, 'page_metadesc'); ?>
            <?php echo $form->textArea($model, 'page_metadesc', array("class" => "form-control")); ?>
            <?php echo $form->error($model, 'page_metadesc'); ?>
        </div>
    </div>
    <div class="col-xs-6">
        <div class="form-group">
            <?php echo $form->labelEx($model, 'page_alias'); ?>
            <?php echo $form->textField($model, 'page_alias', array("class" => "form-control")); ?>
            <?php echo $form->error($model, 'page_alias'); ?>
        </div>


        <div class="form-group">
            <?php echo $form->labelEx($model, 'page_metakeys'); ?>
            <?php echo $form->textArea($model, 'page_metakeys', array("class" => "form-control")); ?>
            <?php echo $form->error($model, 'page_metakeys'); ?>
        </div>

    </div>
</div>
<?php if(class_exists("MediaBrowserWidget")){ ?>
<button type="button" class="btn btn-default" name="btnBrowse" id="btnBrowse">Open Media Browser...</button><br /><br />
        <?php
        $this->widget('MediaBrowserWidget', array(
            "targetbtn" => "#btnBrowse",            
            "id"=>"browser", 
        )); ?>
<?php } ?>
<div class="form-group">
    <?php echo $form->labelEx($model, 'page_content'); ?>
    <?php echo $form->textArea($model, 'page_content', array("class" => "form-control")); ?>
    <?php echo $form->error($model, 'page_content'); ?>
</div>

<div class="row">
    <div class="col-xs-4">
        <div class="form-group">
           
            <?php echo $form->dropDownList($model, 'page_status', array("public"=>"Public","private"=>"Private"), array("class" => "form-control")); ?>
            <?php echo $form->error($model, 'page_status'); ?>
        </div>
    </div>
    <div class="col-xs-4">
        
 
    </div>
    <div class="col-xs-4 text-right">
        <?php echo CHtml::submitButton("Save", array("id" => "formbtnSubmit", "class" => "btn btn-primary ")); ?>
    </div>
</div>



<?php echo $form->hiddenField($model, 'page_id'); ?>
<?php $this->endWidget(); ?>

<script src="<?php echo AssetsManager::i()->getCoreAsset("js/tinymce/tinymce.min.js"); ?>"></script>

<script>
//    var doInsertInFCK = false;
</script>
 
<script>
    var prefix = "#Page_";
    function submitForm(form, data, hasError) {
        if (!hasError) {
            return true;
        }
    }
    
    tinymce.init({
        selector: '#Page_page_content',
        theme: 'modern',
        relative_urls : false,
        remove_script_host : false,
        convert_urls : true,
        height: 400,
        plugins: [
          'advlist autolink link image lists charmap print preview hr anchor pagebreak spellchecker',
          'searchreplace wordcount visualblocks visualchars code fullscreen insertdatetime media nonbreaking',
          'save table contextmenu directionality emoticons template paste textcolor'
        ],
       
        toolbar: 'insertfile undo redo | styleselect | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image | print preview media fullpage | forecolor backcolor emoticons | code'
      });
    

 

    

    $(document).on("click", ".browser .linkbtn_insert", function (e) {
        e.preventDefault();
        var code = '<a href="'+$(this).data("url")+'">'+$(this).data("url")+'</a>';
      
        var type =  $(this).data("type").toString().toLowerCase();
        if(type==="jpg" || type==="jpeg" || type==="png" || type==="gif"){
            code = '<img src="'+$(this).data("url")+'">';
        } 
      
      
      tinymce.activeEditor.insertContent(code);
      
        $(".browser").dialog("close");
    });

</script>
