<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class Slides extends CWidget{
    
    const THEME_DARK = "dark";
    const THEME_LIGHT = "light";
    const THEME_BAR = "bar";
    const THEME_DEFAULT = "default";
    
    
    public function init(){
        parent::init();
        $cs=Yii::app()->clientScript;
        $cs->registerCssFile(AssetsManager::i()->getModuleAsset("slideshow","nivo-slider/nivo-slider.css"));
        $cs->registerCssFile(AssetsManager::i()->getModuleAsset("slideshow","nivo-slider/themes/".$this->theme."/".$this->theme.".css"));
        $cs->registerScriptFile(AssetsManager::i()->getModuleAsset("slideshow","nivo-slider/jquery.nivo.slider.pack.js"));
    }
    
    public $theme = self::THEME_DEFAULT;
    
    public function run(){
        $models = Slideshow::model()->findAll(new CDbCriteria(array("order"=>"sl_order ASC")));        
        $this->render("slideshow",array("models"=>$models));
    }
}