<?php
$config = ModuleLoader::getConfig("slideshow"); 
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
?>

<?php if (count($models) > 0) { ?>
    <div class="slider-wrapper theme-<?php echo $this->theme ?>">
        <div id="slider" class="nivoSlider">
            
            <?php foreach ($models as $model) { 
                $imgurl = Yii::app()->getBaseUrl().$uploadDir.$mediaDir.$model->sl_image;
                $thumburl = ImageHelpers::i()->getThumbImage($imgurl, 120, 120,true); 
            ?>
             
            <a href="<?php echo $model->sl_link; ?>"><img src="<?php echo $imgurl; ?>" data-thumb="<?php echo $thumburl; ?>" alt="" 
                                                  <?php if($model->sl_title!="" || $model->sl_desc!=""){ ?>
                                                  title="#cap-<?php echo $model->sl_id ?>" 
                                                  <?php } ?>
                                                  /></a>
            
            <?php } ?>
            
        </div>
        <?php foreach ($models as $model) { ?>
        <div id="cap-<?php echo $model->sl_id ?>" class="nivo-html-caption">
            <strong><?php echo CHtml::encode($model->sl_title); ?></strong>
            <p>
                <?php echo CHtml::encode($model->sl_desc); ?>
            </p>
        </div>
        <?php } ?>
    </div>
<?php } ?>

<script type="text/javascript">
    $(window).load(function() {
        $('#slider').nivoSlider();
    });
</script>