<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class DefaultController extends AdminController{
    public function __construct($id = null, $module = null) {
        parent::__construct($id, $module);
        TaskComponent::i()->permissionGate("sl_manage_slides");
    }
    public function actionIndex(){
        $this->pageTitle = "Slideshow Manager";
        $formModel = new SlideshowForm();
        $this->render("index",array("formModel"=>$formModel));        
    }
    public function actionLoadlist(){
        $cri = new CDbCriteria();
        $cri->order = "sl_order ASC";
        $models = Slideshow::model()->findAll($cri);
        $data = $this->renderPartial("loadlist", array("models"=>$models), true);
        AjaxOutput::i()->setData($data)->setStatus(true)->display();        
    }
    public function actionSave(){
        $form = new SlideshowForm();
        $params = Yii::app()->request->getParam("SlideshowForm");
        $form->attributes = $params;
        $form->imagefile = CUploadedFile::getInstance($form, "imagefile");
        $form->sl_id = $params["sl_id"];
        if($form->validate()){
            $form->save();
            AjaxOutput::i()->setStatus(true)->display();
        }
        AjaxOutput::i()->
                setValidationStatus(false)->
                setValidationErrors($form->getErrors())->
                display();
    }
    public function actionGet(){
        $id = Yii::app()->request->getParam("id");
        $model = Slideshow::model()->findByPk($id);        
        if(!is_null($model)){
            AjaxOutput::i()->setStatus(true)->setData($model)->display();
        }
        AjaxOutput::i()->setStatus(false)->display();       
    }
    public function actionDelete(){
        $id = Yii::app()->request->getParam("id");
        $form = new SlideshowForm();
        $form->delete($id);
        AjaxOutput::i()->setStatus(true)->display();         
    }
    public function actionSaveorder(){
        $i = 1;
        foreach ($_POST['item'] as $id) {
            Slideshow::model()->updateByPk($id, array("sl_order"=>$i));            
            $i++;
        }
        AjaxOutput::i()->display();
    }
}