<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
/**
 * This is the model class for table "slideshow".
 *
 * The followings are the available columns in table 'slideshow':
 * @property string $sl_id
 * @property string $sl_title
 * @property string $sl_desc
 * @property string $sl_image
 * @property string $sl_link
 * @property string $sl_linktarget
 * @property string $sl_order
 */
class Slideshow extends CActiveRecord
{
	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'slideshow';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		// NOTE: you should only define rules for those attributes that
		// will receive user inputs.
		return array(
			array('sl_linktarget', 'required'),
                        array('sl_title, sl_image, sl_link, sl_desc','length','allowEmpty'=>true),
			array('sl_title, sl_desc, sl_image, sl_link', 'length', 'max'=>255),
			array('sl_linktarget', 'length', 'max'=>6),
			array('sl_order', 'length', 'max'=>11),
			// The following rule is used by search().
			// @todo Please remove those attributes that should not be searched.
			array('sl_id, sl_title, sl_desc, sl_image, sl_link, sl_linktarget, sl_order', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		// NOTE: you may need to adjust the relation name and the related
		// class name for the relations automatically generated below.
		return array(
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'sl_id' => 'Sl',
			'sl_title' => 'Sl Title',
			'sl_desc' => 'Sl Desc',
			'sl_image' => 'Sl Image',
			'sl_link' => 'Sl Link',
			'sl_linktarget' => 'Sl Linktarget',
			 
			'sl_order' => 'Sl Order',
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 *
	 * Typical usecase:
	 * - Initialize the model fields with values from filter form.
	 * - Execute this method to get CActiveDataProvider instance which will filter
	 * models according to data in model fields.
	 * - Pass data provider to CGridView, CListView or any similar widget.
	 *
	 * @return CActiveDataProvider the data provider that can return the models
	 * based on the search/filter conditions.
	 */
	public function search()
	{
		// @todo Please modify the following code to remove attributes that should not be searched.

		$criteria=new CDbCriteria;

		$criteria->compare('sl_id',$this->sl_id,true);
		$criteria->compare('sl_title',$this->sl_title,true);
		$criteria->compare('sl_desc',$this->sl_desc,true);
		$criteria->compare('sl_image',$this->sl_image,true);
		$criteria->compare('sl_link',$this->sl_link,true);
		$criteria->compare('sl_linktarget',$this->sl_linktarget,true);
		 
		$criteria->compare('sl_order',$this->sl_order,true);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}

	/**
	 * Returns the static model of the specified AR class.
	 * Please note that you should have this exact method in all your CActiveRecord descendants!
	 * @param string $className active record class name.
	 * @return Slideshow the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}
        
        
}
