<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class SlideshowForm extends CFormModel {

    public $sl_id;
    public $sl_title;
    public $sl_desc;
    public $sl_image;
    public $sl_link;
    public $sl_linktarget;
    public $imagefile;

    public function rules() {
        // NOTE: you should only define rules for those attributes that
        // will receive user inputs.
        return array(
            array('sl_linktarget', 'required'),
            array('sl_title, sl_desc, sl_image, sl_link','length','allowEmpty'=>true),
            array('sl_title, sl_desc, sl_image, sl_link', 'length', 'max' => 255),
            array('sl_linktarget', 'length', 'max' => 6),
            array('imagefile', 'file', 'types' => 'jpg, jpeg, png, gif', 'allowEmpty' => true),
            array('sl_id, sl_title, sl_desc, sl_image, sl_link, sl_linktarget', 'safe', 'on' => 'search'),
        );
    }

    public function attributeLabels() {
        return array(
            'sl_id' => 'Id',
            'sl_title' => 'Title',
            'sl_desc' => 'Description',
            'sl_image' => 'Image',
            'sl_link' => 'Link',
            'imagefile' => 'Image',
            'sl_linktarget' => 'Link Target',
        );
    }
    
    public function save(){
        $config = ModuleLoader::getConfig("slideshow");         
        MediaManager::i()->setFolder($config["mediaDir"]);
         
        
        if($this->sl_id>0){
            $model = Slideshow::model()->findByPk($this->sl_id);
            if(is_null($model)){
               $model = new Slideshow(); 
            }  
        }else{
            $model = new Slideshow();
            $model->sl_order = 1;
            
            Yii::app()->db
                    ->createCommand("UPDATE slideshow SET sl_order = sl_order + 1")
                    ->execute();
        }
        $filename = $model->sl_image;
        if($model->isNewRecord){
            if(!is_null($this->imagefile)){
              
                $filename = MediaManager::i()->upload($this->imagefile); 
               
            }
        } else {
            if(!is_null($this->imagefile)){
                $filename = MediaManager::i()->upload($this->imagefile,$model->sl_image);                                
            }
        }
        $model->sl_image = $filename;
        $model->sl_title = $this->sl_title;
        $model->sl_desc = $this->sl_desc;        
        $model->sl_link = $this->sl_link;
        $model->sl_linktarget = $this->sl_linktarget;
        if($model->validate()){
            $model->save();
        }
    }
    public function delete($id){
        $config = ModuleLoader::getConfig("slideshow");         
        MediaManager::i()->setFolder($config["mediaDir"]);
        
        $baseDir = Yii::getPathOfAlias("webroot");
        $uploadDir = Yii::app()->params["uploadDir"];
        $mediaDir = $config["mediaDir"];
        $model = Slideshow::model()->findByPk($id);
        if(!is_null($model)){
             
                MediaManager::i()->delete($model->sl_image);                
            
            Yii::app()->db
                    ->createCommand("UPDATE slideshow SET sl_order = sl_order - 1 WHERE sl_order > :order")
                    ->execute(array(":order"=>$model->sl_order));
            $model->delete();
        }
    }
}
