<?php
$config = ModuleLoader::getConfig("slideshow"); 
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
?>
 

<div class="row">
    <div class="btn-toolbar  col-xs-4">
        <div class="input-group">    
            <?php echo CHtml::htmlButton("New Slide", array("id" => "btnNewWidget", "class" => "btn btn-primary ", "name" => "btnNewWidget")); ?>
        </div>
    </div>
</div>
 
<div id="listdata" class="listdata">

</div>


<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form', 'enctype' => 'multipart/form-data'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
<div class="clearfix">
    <div class="col-xs-6">
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'sl_title'); ?>
            <?php echo $form->textField($formModel, 'sl_title', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'sl_title'); ?>
        </div>        
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'sl_desc'); ?>
            <?php echo $form->textArea($formModel, 'sl_desc', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'sl_desc'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'sl_link'); ?>
            <?php echo $form->textField($formModel, 'sl_link', array("class" => "form-control","placeholder"=>"http://")); ?>
            <?php echo $form->error($formModel, 'sl_link'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'sl_linktarget'); ?>
            <?php echo $form->dropDownList($formModel, 'sl_linktarget', array("_self"=>"Same Window","_blank"=>"New Window") ,array("class" => "form-control","placeholder"=>"http://")); ?>
            <?php echo $form->error($formModel, 'sl_linktarget'); ?>
        </div> 
    </div>


    <div class="col-xs-6">

        <div class="imagepreview">
            <a data-lightbox="image" href="" target="_blank">
            <img  class="thumbnail" src="" alt="" /><br />
            </a>
        </div>
        <div class="form-group"> 

            <?php echo $form->labelEx($formModel, 'imagefile'); ?>
            <?php echo $form->fileField($formModel, 'imagefile',array("accept"=>"image/jpeg,image/png,image/gif")) ?>
            <?php echo $form->error($formModel, 'imagefile'); ?>
        </div>
    </div>

    
</div>

<p class="text-right">
    <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
</p>
<?php echo $form->hiddenField($formModel, 'sl_id'); ?>
<?php $this->endWidget(); ?>










<script>
   loadList();
        
        function loadList() {
        $.ajax({
            
            url: "<?php echo $this->createUrl("loadlist"); ?>",
            success: function(response, textStatus, XMLHttpRequest) {   
                if(serverValidation(response)===true){
                  
                    $("#listdata").html(response.data.result);                
                }
            }
        });
    }
    function submitForm(form, data, hasError) {
        
        if (!hasError) {
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList();
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
   
     
    $("#SlideshowForm_imagefile").on("change",function(){
        var file_type = $(this).get(0).files[0].type.toLowerCase();
        var file_size = $(this).get(0).files[0].size;
        var max_file_size = <?php echo Helpers::i()->returnBytes(ini_get("upload_max_filesize")); ?>;

        if(file_size>max_file_size){
            $(this).val('');
            alert("File is larger than the maximum size allowed. Max upload size: <?php echo ini_get("upload_max_filesize") ?>");
        }

        if(file_type=="image/jpg" || file_type=="image/jpeg" || file_type=="image/png" || file_type=="image/gif"){

        } else {
           $(this).val('');
           alert("Only image files are allowed.");
        }
    });
     
       
     //$("#form").dialog({autoOpen: false, width: 660, position: ['center', 'middle'], modal: true});
     $("#form").dialog({autoOpen: false, width: 660,  modal: true});
     
     $(document).on("click", ".linkbtn_edit", function() {
        var id = $(this).attr("data-id");
        $.ajax({
            
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(response, textStatus, XMLHttpRequest) {
                var mdl = response.data.result; 
                var imgsrc = "<?php echo Yii::app()->getBaseUrl() . $uploadDir.$mediaDir; ?>" + mdl.sl_image;
                var thumbsrc = "<?php echo ImageHelpers::i()->getThumbImageSq("T_imgsrc", 283); ?>";
                thumbsrc = thumbsrc.replace("T_imgsrc", imgsrc); 
                $(".imagepreview img").attr("src", thumbsrc);
                $(".imagepreview a").attr("href", imgsrc);
                populateForm("#form", response.data.result, "SlideshowForm");
                $("#SlideshowForm_imagefile").val("");
                $("#form").dialog("option", "title", "Edit").dialog("open");
            }
        });
    });
    $(document).on("click", ".linkbtn_delete", function() {
        var id = $(this).attr("data-id");
        var answer = confirm("Are you sure?");
        if (answer) {
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(response, textStatus, XMLHttpRequest) {
                    loadList();
                }
            });
        }
    });
    
    $("#btnNewWidget").on("click", function() {    
        resetForm("#form");  
        $(".imagepreview img").attr("src", "<?php echo ImageHelpers::i()->getDefaultImageSq(200); ?>");
         
                $(".imagepreview a").attr("href", "#");
        $("#form").dialog("option", "title", "New").dialog("open");         
    });
 
    
     
</script>