<?php
$config = ModuleLoader::getConfig("slideshow"); 
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
        
if (count($models) > 0) {
    ?>
    <div id="sortable">
        <?php foreach ($models as $model) { ?>
            <div class="rowbox " id="item-<?php echo $model->sl_id; ?>">
                <div class="row">
                     
                    <div class="col-xs-2">
                        <?php 
                        $imgurl = Yii::app()->getBaseUrl().$uploadDir.$mediaDir.$model->sl_image;
                        $thumburl = ImageHelpers::i()->getThumbImage($imgurl, 120, 120,true); ?>
                        <a class="thumbnail" href="<?php echo $imgurl; ?>" data-lightbox="image-<?php echo $model->sl_id; ?>">
                        <img src="<?php echo $thumburl ?>" alt="preview" />
                        </a>
                    </div>
                    <div class="col-xs-10">
                        <strong><?php echo CHtml::encode($model->sl_title); ?></strong>
                        <p>
                            <?php echo CHtml::encode($model->sl_desc); ?>
                        </p>
                        <p>
                        <?php echo AdminHelpers::i()->linkbtnEdit($model->sl_id); ?>
                        <?php echo AdminHelpers::i()->linkbtnDelete($model->sl_id); ?>
                        </p>
                    </div>
                </div>
            </div> 
        <?php } ?>
    </div>
<?php } ?>

<script>
$(function() {
    $( "#sortable" ).sortable({
        axis: 'y',
        update: function (event, ui) {
            var data = $(this).sortable('serialize');
       
            // POST to server using $.post or $.ajax
            $.ajax({
                data: data,
                type: 'POST',
                url: '<?php echo $this->createUrl("saveorder") ?>'
            });
        }
    });
    $( "#sortable" ).disableSelection(); 
});
</script>