<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class BackgroundSettings extends AbstractAdminSettingsForm {

    
    
    public $bg_image;
    public $bg_image_repeat = "no-repeat";
    public $bg_color = "eaeaea";
    public $bg_image_position = "top center";
    public $bg_image_attachment = "fixed";
    
    public $file;
     
    public function __construct() {
        parent::__construct();
        $obj = $this;
        $this->onBeforeSavingForm = function(CEvent $event) use (&$obj) {
            $path = Yii::getPathOfAlias("webroot") . Yii::app()->params["uploadDir"];
            
            if(isset($_POST["delete_bg_image"])){
                
                $img = Settings::i()->get("bg_image", get_called_class());
               
                if(file_exists($path.$img) && !is_dir($path.$img)){
                    
                    unlink($path.$img);
                }
                Settings::i()->save("bg_image", "" ,get_called_class());
                Settings::i()->init();
                $obj->bg_image = "";
            }
            
            $up = CUploadedFile::getInstance($obj, "file");
            if(!is_null($up)){                
                $img = Settings::i()->get("bg_image", get_called_class());
                if(file_exists($path.$img) && !is_dir($path.$img)){
                    unlink($path.$img);
                }
                $filename = uniqid();                           
                $file = $path.$filename.".".$up->extensionName;
                $up->saveAs($file);
                $obj->bg_image = $filename.".".$up->extensionName;
                $obj->file = "";
            } else {
                $obj->file = "";
                $obj->bg_image = Settings::i()->get("bg_image", get_called_class());
            }
             
        };
    }

    public function getExcludedProperties() {
        return array("file");
    }
    
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("bg_image_repeat, bg_color, bg_image_position, bg_image_attachment", "required");
        $rules[] = array("bg_image", "length", "allowEmpty" => true);
        $rules[] = array('file', 'file', 'types' => 'jpg, jpeg, png, gif', 'allowEmpty' => true);
        return $rules;
    }

    public function attributeLabels() {
        $l = parent::rules();
        $l["file"] = "Background Image";
        $l["bg_image"] = "Background Image";
        $l["bg_image_repeat"] = "Background Image Repeat";
        $l["bg_color"] = "Background Color";
        $l["bg_image_position"] = "Background Position";
        
        $l["bg_image_attachment"] = "Background Attachment";
        return $l;
    }

    public function adminForm() {
         
        
        $repeats = array(
            "no-repeat" => "No Repeat",
            "repeat" => "Repeat",
            "repeat-x" => "Repeat X",
            "repeat-y" => "Repeat Y"
        );
        $positions = array(
            "top left" => "Top Left",
            "top right" => "Top Right",
            "top center" => "Top Center",
            "bottom left" => "Bottom Left",
            "bottom right" => "Bottom Right",
            "bottom center" => "Bottom Center",
        );
$attachments = array("fixed" => "Fixed", "scroll" => "Scroll");
        echo "<div class='row'>";
        echo "<div class='col-xs-8'>";

        echo CHtml::openTag("div", array("class" => "form-group"));
        echo $this->form->label($this, "file");
        echo $this->form->fileField($this, "file", array("class" => "form-control"));
        echo $this->form->error($this, "file");
        echo "Note: If you upload an image then you will have to refresh this page to see the new logo";
        echo CHtml::closeTag("div");

        echo "</div>";
        echo "<div class='col-xs-4'>";
        
            $imgurl = Yii::app()->getBaseUrl() . Yii::app()->params["uploadDir"] . $this->bg_image;
            $imgtag = CHtml::image(ImageHelpers::i()->getThumbImage($imgurl, 150), "", array("class" => "thumbnail","id"=>"bg_image"));
            echo CHtml::link($imgtag, $imgurl);
            echo CHtml::checkBox("delete_bg_image")." Delete Image <br /><br />";
       
        echo "</div>";
        echo "</div>";

        

        echo "<div class='row'>";
        echo "<div class='col-xs-6'>";
        echo CHtml::openTag("div", array("class" => "form-group"));
        echo $this->form->label($this, "bg_color");
        echo $this->form->textField($this, "bg_color", array("class" => "form-control"));
        echo $this->form->error($this, "bg_color");
        echo CHtml::closeTag("div");
        echo "</div>";
        echo "<div class='col-xs-6'>";
        echo CHtml::openTag("div", array("class" => "form-group"));
        echo $this->form->label($this, "bg_image_position");
        echo $this->form->dropDownList($this, "bg_image_position", $positions, array("class" => "form-control"));
        echo $this->form->error($this, "bg_image_position");
        echo CHtml::closeTag("div");
        echo "</div>";

        echo "<div class='col-xs-6'>";
        echo CHtml::openTag("div", array("class" => "form-group"));
        echo $this->form->label($this, "bg_image_repeat");
        echo $this->form->dropDownList($this, "bg_image_repeat", $repeats, array("class" => "form-control"));
        echo $this->form->error($this, "bg_image_repeat");
        echo CHtml::closeTag("div");
        echo "</div>";
        
        echo "<div class='col-xs-6'>";
        echo CHtml::openTag("div", array("class" => "form-group"));
        echo $this->form->label($this, "bg_image_attachment");
        echo $this->form->dropDownList($this, "bg_image_attachment", $attachments, array("class" => "form-control"));
        echo $this->form->error($this, "bg_image_attachment");
        echo CHtml::closeTag("div");
        echo "</div>";
        
        echo "</div>";
 
        ?>
        <script type="text/javascript">

            $(document).ready(function() {

                $("#<?php echo get_class($this) ?>_bg_color").pickAColor({
                    showSavedColors: false,
                });

            });
 
            var formElement = document.getElementById("formSettings_<?php echo get_called_class() ?>");
            formElement.addEventListener("formAjaxResponse", function(e) {
              var img_url = "<?php echo Yii::app()->getBaseUrl(true).Yii::app()->params["uploadDir"] ?>"+e.detail.data.bg_image;
              var resize_url = "<?php echo ImageHelpers::i()->getThumbImage("T_Url", 150); ?>";
              var thumb_url = resize_url.replace("T_Url",img_url);
              $("input[type=file]").val("");
              $("#delete_bg_image").prop("checked",false);
              $("#bg_image").attr("src",thumb_url);
            })
 

        </script>
        <?php
    }

}
