<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class BasicSettings extends AbstractAdminSettingsForm{
    
    public $contact_email;
    
    public $site_title;
    public $site_description;
    public $site_keywords;
    public $site_hometitle;
    public $site_credit;
    
    public $theme = "press";
    public $homepage;
    public $contact_text;
    public $site_logo;
    public $language = "default";
    
    public $cache_duration = 0;
    public $code_at_head;
    public $code_at_foot;
        
    public $file;
    
    public $clear_site_cache;
    public $clear_image_cache;
    
    public $resized_image_quality = 90;
    
    
    public function __construct() {
        parent::__construct();
        $obj = $this;
        
        $this->onBeforeSavingForm = function(CEvent $event) use (&$obj){
            
            $path = Yii::getPathOfAlias("webroot").Yii::app()->params["uploadDir"];
            if(isset($_POST["delete-logo"])){
                $site_logo = Settings::i()->get("site_logo", "BasicSettings");
                if(file_exists($path.$site_logo) && !is_dir($path.$site_logo)){
                    unlink($path.$site_logo);
                }
                Settings::i()->save("site_logo", "" ,get_called_class());
                Settings::i()->init();
                $obj->site_logo = "";
            }
            
            $up = CUploadedFile::getInstance($obj, "file");
            if(!is_null($up)){                
                $site_logo = Settings::i()->get("site_logo", "BasicSettings");
                if(file_exists($path.$site_logo)  && !is_dir($path.$site_logo)){
                    unlink($path.$site_logo);
                }
                $filename = uniqid();                           
                $file = $path.$filename.".".$up->extensionName;
                $up->saveAs($file);
                $obj->site_logo = $filename.".".$up->extensionName;
                $obj->file = "";
            } else {
                $obj->site_logo = Settings::i()->get("site_logo", "BasicSettings");
            }
            
            
            if($obj->clear_site_cache==true){
                $path = Yii::getPathOfAlias("application.runtime.cache");
                $files = glob($path."/*"); 
                foreach($files as $file){ 
                  if(is_file($file)){
                    unlink($file); 
                  }
                }
            }
            $obj->clear_site_cache=null;
            
            if($obj->clear_image_cache==true){
                $path = Yii::getPathOfAlias("application.runtime.imagecache");
                $files = glob($path."/*"); 
                foreach($files as $file){ 
                  if(is_file($file)){
                    unlink($file); 
                  }
                }
            }
            $obj->clear_image_cache=null;    
        };
        
    }

    public function getExcludedProperties() {
        return array(
            "file","clear_image_cache","clear_site_cache"
        );
    }
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("language, homepage,contact_email, theme, resized_image_quality", "required");
        $rules[] = array("site_credit, clear_site_cache, clear_image_cache, site_title, site_hometitle, cache_duration, code_at_head, code_at_foot, site_description, site_keywords, contact_text, site_logo", "length","allowEmpty"=>true);
        $rules[] = array('file', 'file', 'types' => 'jpg, jpeg, png, gif', 'allowEmpty'=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $attr = parent::attributeLabels();
        $attr["file"] = "Site Logo";
        $attr["site_title"] = "Site Title";
        $attr["site_description"]= "Description";
        $attr["site_keywords"] = "Keywords";
        $attr["site_credit"] = "Credit";
        
        $attr["theme"] = "Theme";
        $attr["homepage"] = "Homepage"; 
        $attr["contact_text"] = "Contact Page Text"; 
        
        $attr["code_at_head"] = "Code just before closing of Head tag"; 
        $attr["code_at_foot"] = "Code just before closing of Body tag";
        
        
        $attr["clear_site_cache"] = "Check this to clear site cache";
        $attr["clear_image_cache"] = "Check this to clear image cache";
        
        return $attr;
    }
     
    
    public function adminForm() {
         
        $imgurl = Yii::app()->getBaseUrl().Yii::app()->params["uploadDir"].$this->site_logo;        
        $imgtag = CHtml::image($imgurl,"",array("class"=>"thumbnail","id"=>"site_logo","style"=>"max-width:600px"));
        echo CHtml::link($imgtag,$imgurl);
        echo CHtml::checkBox("delete-logo")." Delete Logo <br /><br />";
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "file");
        echo $this->form->fileField($this, "file",array("class"=>"form-control"));
        echo $this->form->error($this, "file");
        echo "Note: If you upload a logo then you will have to refresh this page to see the new logo";
        echo CHtml::closeTag("div");
        
         
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "site_title");
        echo $this->form->textField($this, "site_title",array("class"=>"form-control"));
        echo $this->form->error($this, "site_title");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "site_description");
        echo $this->form->textArea($this, "site_description",array("class"=>"form-control"));
        echo $this->form->error($this, "site_description");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "site_keywords");
        echo $this->form->textArea($this, "site_keywords",array("class"=>"form-control"));
        echo $this->form->error($this, "site_keywords");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "site_hometitle");
        echo $this->form->textField($this, "site_hometitle",array("class"=>"form-control"));
        echo $this->form->error($this, "site_hometitle");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "site_credit");
        echo $this->form->textField($this, "site_credit",array("class"=>"form-control"));
        echo $this->form->error($this, "site_credit");
        echo CHtml::closeTag("div");
                
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "contact_email");
        echo $this->form->textField($this, "contact_email",array("class"=>"form-control","placeholder"=>"eg. yourname@example.com"));
        echo $this->form->error($this, "contact_email");
        echo CHtml::closeTag("div");
        
        $folders = scandir(Yii::getPathOfAlias("webroot.themes"));
        $folderlist["none"] = "--None--";
        foreach ($folders as $folder) {
            if ($folder != "." && $folder != "..") {
                $folderlist[$folder] = ucfirst($folder);
            }
        }
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "theme");
        echo $this->form->dropDownList($this,"theme",$folderlist,array("class"=>"form-control"));
        echo $this->form->error($this, "theme");
        echo CHtml::closeTag("div");
        
        $dir = Yii::getPathOfAlias("application.messages");
        $folders = scandir($dir);
        $languagelist["default"] = "Default(English)";
        foreach ($folders as $folder) {
            
            if ($folder != "." && $folder != ".." && is_dir($dir."/".$folder)) {
                $languagelist[$folder] = ucfirst($folder);
            }
        }
       
        $modules = ModuleLoader::listModules();
    
        foreach($modules as $module){
            $dir = Yii::getPathOfAlias("application.modules.".$module.".messages");
            if(file_exists($dir)){
                $folders = scandir($dir);         
                foreach ($folders as $folder) {
                    if ($folder != "." && $folder != ".." && is_dir($dir."/".$folder)) {                        
                        $languagelist[$folder] = strtoupper($folder);
                    }
                }
            }
        }
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "resized_image_quality");
        echo $this->form->textField($this, "resized_image_quality",array("class"=>"form-control"));
        echo $this->form->error($this, "resized_image_quality");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "cache_duration");
        echo $this->form->textField($this, "cache_duration",array("class"=>"form-control"));
        echo $this->form->error($this, "cache_duration");
        echo CHtml::closeTag("div");
         
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "clear_site_cache");
        echo "&nbsp;".$this->form->checkBox($this,"clear_site_cache");
        echo $this->form->error($this, "clear_site_cache");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "clear_image_cache");
        echo "&nbsp;".$this->form->checkBox($this,"clear_image_cache");
        echo $this->form->error($this, "clear_image_cache");
        echo CHtml::closeTag("div");        
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "language");
        echo $this->form->dropDownList($this,"language",$languagelist,array("class"=>"form-control"));
        echo $this->form->error($this, "language");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "homepage");
        echo $this->form->dropDownList($this,"homepage",ModuleLoader::getHomePages(),array("class"=>"form-control"));
        echo $this->form->error($this, "homepage");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "contact_text");
        echo $this->form->textArea($this, "contact_text",array("class"=>"form-control","style"=>"height:200px"));
        echo $this->form->error($this, "contact_text");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "code_at_head");
        echo $this->form->textArea($this, "code_at_head",array("class"=>"form-control","style"=>"height:250px"));
        echo $this->form->error($this, "code_at_head");
        echo CHtml::closeTag("div");
                
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "code_at_foot");
        echo $this->form->textArea($this, "code_at_foot",array("class"=>"form-control","style"=>"height:250px"));
        echo $this->form->error($this, "code_at_foot");
        echo CHtml::closeTag("div");
        
        ?>
<script>
    var current_theme = $("#<?php echo get_called_class() ?>_theme").val();
    var formElement = document.getElementById("formSettings_<?php echo get_called_class() ?>");
            formElement.addEventListener("formAjaxResponse", function(e) {          
              $("#site_logo").attr("src","<?php echo Yii::app()->getBaseUrl(true).Yii::app()->params["uploadDir"] ?>"+e.detail.data.site_logo+"?s="+Math.random());
              $("input[type=file]").val("");
              $("#delete-logo").prop("checked",false);
              
              if(current_theme!=$("#<?php echo get_called_class() ?>_theme").val()){
                  location.reload();
              }
            })
    </script>
<?php
    }
    
    
    
}