<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class EmailSettings extends AbstractAdminSettingsForm{
     
 
    public $smtp_host;
    public $smtp_username;
    public $smtp_password;
    public $smtp_secure;
    public $smtp_port;
    public $smtp_require_auth;
    
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("smtp_host, smtp_username, smtp_password, smtp_port, smtp_require_auth", "required");        
        $rules[] = array("smtp_secure","length","allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $attr = parent::attributeLabels();
        $attr["smtp_host"] = "Host";
        $attr["smtp_username"]= "Username";
        $attr["smtp_password"] = "Password";
        $attr["smtp_secure"] = "Secure";
        $attr["smtp_port"] = "Port";
        $attr["smtp_require_auth"] = "Requires Authentication";
        return $attr;
    }
    
    public function adminForm() {
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "smtp_host");
        echo $this->form->textField($this, "smtp_host",array("class"=>"form-control"));
        echo $this->form->error($this, "smtp_host");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "smtp_port");
        echo $this->form->textField($this, "smtp_port",array("class"=>"form-control"));
        echo $this->form->error($this, "smtp_port");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "smtp_require_auth");
        echo $this->form->dropDownList($this, "smtp_require_auth", array("1"=>"Yes","0"=>"No") , array("class"=>"form-control"));
        echo $this->form->error($this, "smtp_require_auth");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "smtp_username");
        echo $this->form->textField($this, "smtp_username",array("class"=>"form-control"));
        echo $this->form->error($this, "smtp_username");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "smtp_password");
        echo $this->form->passwordField($this, "smtp_password",array("class"=>"form-control"));
        echo $this->form->error($this, "smtp_password");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "smtp_secure");
        echo $this->form->dropDownList($this, "smtp_secure", array(""=>"None","tls"=>"TLS","ssl"=>"SSL") , array("class"=>"form-control"));
        echo $this->form->error($this, "smtp_secure");
        echo CHtml::closeTag("div");
    }
    
}