<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class FeedSettings extends AbstractAdminSettingsForm{
    
 
    public $feed_title;
    public $feed_description;
    public $feed_lang = "en-us";
    public $feed_pubdate;
     
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("feed_title, feed_lang, feed_pubdate", "required");
        $rules[] = array("feed_description", "length","allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $attr = parent::attributeLabels();
        $attr["feed_title"] = "Title";
        $attr["feed_description"]= "Description";
        $attr["feed_lang"] = "Language";
        $attr["feed_pubdate"] = "Date";
        
        return $attr;
    }
    
    public function adminForm() {
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "feed_title");
        echo $this->form->textField($this, "feed_title",array("class"=>"form-control"));
        echo $this->form->error($this, "feed_title");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "feed_description");
        echo $this->form->textArea($this, "feed_description",array("class"=>"form-control"));
        echo $this->form->error($this, "feed_description");
        echo CHtml::closeTag("div");
         
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "feed_lang");
        echo $this->form->textField($this, "feed_lang",array("class"=>"form-control"));
        echo $this->form->error($this, "feed_lang");
        echo CHtml::closeTag("div");
        
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, "feed_pubdate");
        echo $this->form->textField($this, "feed_pubdate",array("class"=>"form-control"));
        echo $this->form->error($this, "feed_pubdate");
        echo CHtml::closeTag("div");
        ?>
        <script>
            $("#FeedSettings_feed_pubdate").datepicker({
                dateFormat: "dd-MM-yy"
            });
        </script>
<?php        
    }
    
    
    
}