<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class SocialSettings extends AbstractAdminSettingsForm{
    
    public $rss;
    public $facebook;
    
    public $twitter;
    public $linkedin;
    public $googleplus;
    public $youtube;
    
    
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("rss, facebook,   twitter, linkedin, googleplus, youtube", "length", "allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $attr = parent::attributeLabels();
        $attr["rss"]= "RSS";
        $attr["facebook"]= "Facebook";
         
        $attr["twitter"]= "Twitter";
        $attr["linkedin"]= "LinkedIn";
        $attr["googleplus"]= "Google+";   
        $attr["youtube"]= "YouTube";
        return $attr;
    }
    
    public function adminForm() {
        
        $sites = array("rss", "facebook",   "twitter", "linkedin", "googleplus", "youtube");
         
        foreach($sites as $site){
        echo CHtml::openTag("div",array("class"=>"form-group"));
        echo $this->form->label($this, $site);
        echo $this->form->textField($this, $site,array("class"=>"form-control","placeholder"=>"http://"));
        echo $this->form->error($this, $site);
        echo CHtml::closeTag("div");
        }
        
        
    }
    
    
    
}