<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class ImageWidget extends AbstractWidget {
    
    public $image_src;
    public $image_link;
    public $target;
    public function adminForm() {
        echo "<div class='form-group'>";
        echo $this->form->label($this, "image_src");
        echo $this->form->textField($this, "image_src",array("class"=>"form-control"));
        echo $this->form->error($this, "image_src");
        echo "</div>";
        
        echo "<div class='form-group'>";
        echo $this->form->label($this, "image_link");
        echo $this->form->textField($this, "image_link",array("class"=>"form-control"));
        echo $this->form->error($this, "image_link");
        echo "</div>";
        
        echo "<div class='form-group'>";
        echo $this->form->label($this, "target");
        echo $this->form->dropDownList($this, "target", array("_self"=>"Same Window","_blank"=>"New Window") ,array("class"=>"form-control"));
        echo $this->form->error($this, "target");
        echo "</div>";
    }

    

    public function rules() {
        $rules = parent::rules();
        $rules[] = array("image_src, target", "required");
        $rules[] = array("image_link", "length","allowEmpty"=>true);
        return $rules;
    }
    
    public function attributeLabels() {
        $labels = parent::attributeLabels();
        $labels["image_src"] = "Image Source Url";
        $labels["image_link"] = "Link";
        $labels["target"] = "Open In...";
        return $labels;
    }

    public function render($arg, $data) {
        if(trim($data["image_link"])==""){
            
            $body = CHtml::image($data["image_src"],$arg["title"]);
        } else {
            $body = CHtml::link(CHtml::image($data["image_src"],$arg["title"]),$data["image_link"],array("target"=>$data["target"]));
        }
        
        
        
        $r["title"] = $arg["title"];
        $r["body"] = $body;
        return $r;
    }

}