<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class MenuWidget extends AbstractWidget {

    public function adminForm() {
        echo "<div class='form-group'>";
        echo $this->form->label($this, "m_id");
        echo $this->form->dropDownList($this, "m_id", CHtml::listData(Menu::model()->findAll(), "m_id", "m_name"),array("class"=>"form-control"));
        echo $this->form->error($this, "m_id");
        echo "</div>";
    }

    public $m_id;

    public function rules() {
        $rules = parent::rules();
        $rules[] = array("m_id", "required");
        return $rules;
    }

    public function attributeLabels() {
        $labels = parent::attributeLabels();
        $labels["m_id"] = "Menu";
        return $labels;
    }

    public function render($arg, $data) {
        
        $render = function($menuitems) use(&$render){
            $str = "";
            if(!is_array($menuitems)){ return ""; }
            foreach($menuitems as $item){
                if(count($item["children"])>0){
                    $str .= "<li>";
                    $str .= CHtml::link($item["title"],$item["url"],array("target"=>$item["target"]));
                    
                    $str .= "</li>";
                    $str .= "<ul>";
                    $str .= $render($item["children"]);
                    $str .= "</ul>";
                } else {
                    $str .= '<li>'.CHtml::link($item["title"],$item["url"],array("target"=>$item["target"])).'</li>';
                }
            }
            return $str;
        };
        
        
        $body = "";
        $m_id = $data["m_id"];        
        $menuitems = MenuComponent::i()->loadMenuitemsByMenuId($m_id);
        if($menuitems!=""){
            $body .= "<ul>";
            $body .= $render($menuitems);
            $body .= "</ul>";
        }
         
        $r["title"] = $arg["title"];
        $r["body"] = $body;
        return $r;
    }

}