<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class SocialWidget extends AbstractWidget {
    public $size;
    public $icontype;
    public function adminForm() {
        echo "<div class='form-group'>";
        echo $this->form->label($this, "size");
        echo $this->form->textField($this, "size",array("class"=>"form-control"));
        echo $this->form->error($this, "size");
        echo "</div>";
        
        echo "<div class='form-group'>";
        echo $this->form->label($this, "icontype");
        echo $this->form->dropDownList($this, "icontype", array("font"=>"Font Based","image"=>"Image Based") ,array("class"=>"form-control"));        
        echo $this->form->error($this, "icontype");
        echo "</div>";
    }

    

    public function rules() {
        $rules = parent::rules();
        $rules[] = array("size, icontype", "required");
        return $rules;
    }

   private $_assetsUrl;
    private function getAssetsUrl() {
        if(is_null($this->_assetsUrl)){
            $assetsPath = __DIR__."/SocialWidget_assets/";
            $this->_assetsUrl = Yii::app()->getAssetManager()->publish($assetsPath);
        }
        return $this->_assetsUrl;
    }
 

    public function render($arg, $data) {
        $body = "";
        
          
        
        $sites = array("rss"=>"rss", "facebook"=>"facebook", "twitter"=>"twitter", "linkedin"=>"linkedin", "googleplus"=>"google-plus", "youtube"=>"youtube-play");        
        if($data["icontype"]=="font"){       
             $cs = Yii::app()->getClientScript();    
        $cs->registerCssFile(AssetsManager::i()->getCoreAsset("font-awesome/css/font-awesome.min.css"));
        
        $mw = ((int)$data["size"]*3) . "px";
        $pd = ((int)$data["size"]/3) . "px";
        $size = $data["size"];
            $style = <<<EOF
                 
                .social_outer{
                    clear:both;
                    padding:5px;
                }
                .social{  
                    text-align:center;                 
                     display:inline-block;
                    min-width:$mw;
                    padding:$pd;               
                    color:white;
                    font-size:$size;
                }
                .social:hover, .social:focus, .social:active{
                    color:white;
                    opacity:0.9;
                    text-decoration:none;
                }
                .facebook{ background-color:#3B5B99; }
                .twitter{ background-color:#29A8E1; }
                .google-plus{ background-color:#E14B36 }
                .linkedin{ background-color:#1979BB }
                .rss{ background-color:#FF962D }
                .youtube-play{ background-color:#CC181E }
                
EOF;
            Yii::app()->getClientScript()->registerCss("social_widget_css", $style);                            
            $body = "<div class='social_outer' style='font-size:".$data["size"]."px'>";
            foreach($sites as $site=>$icon){             
               $url = SocialSettings::i()->$site;
               if(trim($url)!=""){                
                    $body .= CHtml::link("<i class='fa fa-".$icon."'></i>", $url, array("target" => "_blank","class"=>"grow $icon social"));
               }
            }
            $body .= "</div>";        
        } else if($data["icontype"]=="image"){
            foreach($sites as $site=>$label){             
               $url = SocialSettings::i()->$site;
               if(trim($url)!=""){           
                   $img = CHtml::image($this->getAssetsUrl()."/".$site.".png",$site,array("style"=>"width:".$data["size"]."px; height:auto;margin:2px"));
                   $body .= CHtml::link($img, $url, array("class"=>"grow", "target" => "_blank"));
               }
            }
        }
        $r["title"] = $arg["title"];
        $r["body"] = $body;
        return $r;
    }

}