<?php

if (count($models) > 0) {
    ?>
    <div id="sortable">
        <?php foreach ($models as $model) { ?>
            <div class="rowbox " id="item-<?php echo $model->wd_id; ?>">
                <div class="row">
                    <div class="col-xs-2">    
                        <?php echo AdminHelpers::i()->linkbtnEdit($model->wd_id); ?>
                        <?php echo AdminHelpers::i()->linkbtnDelete($model->wd_id); ?>
                    </div>
                    <div class="col-xs-10">
                        <div class="col-xs-7">
                        <?php echo CHtml::encode($model->wd_title); ?> 
                        </div>
                        <span class="label label-info">
                            <?php echo str_replace("Widget", "", $model->wd_type); ?>
                        </span>
                    </div>
                </div>
            </div> 
        <?php } ?>
    </div>
<?php } ?>

<script>
$(function() {
    $( "#sortable" ).sortable({
        axis: 'y',
        update: function (event, ui) {
            var data = $(this).sortable('serialize');
       
            // POST to server using $.post or $.ajax
            $.ajax({
                data: data+"&wd_panel=<?php echo Yii::app()->request->getParam("wd_panel",0) ?>",
                type: 'POST',
                url: '<?php echo $this->createUrl("widget_saveorder") ?>'
            });
        }
    });
    $( "#sortable" ).disableSelection(); 
});
</script>