<div class="btn-toolbar clearfix">    
    <button type="button" name="btnNew" id="btnNew" class="btn btn-primary">Add New Question</button>  
</div>

<table class="table">
    <thead>
        <tr>
            <th class="col-xs-2">Actions</th>
            <th>Question</th>
            <th class="col-xs-2">Answer</th>
            <th class="col-xs-2">Case Sensitive</th>                        
        </tr>
    </thead>
    <tbody id="tbodyList">
        
    </tbody>
    <tfoot>
        <tr>
            <td colspan="4">
                <div id="pager" class="pager"></div>
            </td>
        </tr>
    </tfoot>
</table>

<!-- Templates -->
<p style="display:none">
    <textarea id="templateList" rows="0" cols="0">
<!--      
    {#foreach $T.records as r}
        <tr>
            <td>                
                <?php echo AdminHelpers::i()->linkbtnEdit('{$T.r.qa_id}'); ?> 
                <?php echo AdminHelpers::i()->linkbtnDelete('{$T.r.qa_id}'); ?>
            </td>
            <td>{$T.r.qa_question}</td>
            <td>{$T.r.qa_answer}</td>            
            <td>
                {#if $T.r.qa_casesensitive == 1} 
                <span class="label label-warning">Yes</span>
                {#else}
                <span class="label label-success">No</span>
                {#/if} 
            </td>
        </tr> 
    {#/for}
-->
    </textarea>
</p>
<!-- //Templates -->


<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
    <div class="clearfix"> 
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'qa_question'); ?>
            <?php echo $form->textField($formModel, 'qa_question', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'qa_question'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'qa_answer'); ?>
            <?php echo $form->textField($formModel, 'qa_answer', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'qa_answer'); ?>
        </div>
        <div class="checkbox">
            <label>
            <?php echo $form->checkBox($formModel, 'qa_casesensitive', array( "value"=>"1")); ?>
            <?php echo $formModel->getAttributeLabel("qa_casesensitive") ?>
            </label>
        </div> 
    </div> 
    <p class="text-right">
        <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
    </p>
    <?php echo $form->hiddenField($formModel, 'qa_id'); ?>
<?php $this->endWidget(); ?>

    
<script>
 
    var page = 1;
    var total = 0;
    var perpage = <?php echo $this->perpage ?>;
    
    loadList(1);
    
    function getPageCount() {
        if (total > 0) {
            return Math.ceil(total /perpage);
        }
        return 0;
    }
    
    function pageClick(pageclickednumber) {
        $("#pager").pager({pagenumber: pageclickednumber, pagecount: getPageCount(), buttonClickCallback: pageClick});
        loadList(pageclickednumber);
    }
    
    function loadList(cpage){
        
        $.ajax({
            data: {"page": cpage },
            url: "<?php echo $this->createUrl("loadlist"); ?>",
            success: function(response, textStatus, XMLHttpRequest) {
                if (serverValidation(response) == true) {
                    if (response.status == true) {
                        $("#tbodyList").setTemplateElement("templateList").processTemplate(response.data.result);
                        total = response.data.result.total;
                    } else {
                        $("#tbodyList").html("No Records Found");
                    }
                }

                page = cpage;
                if (page == 1) {
                    $("#pager").pager({pagenumber: page, pagecount: getPageCount(), buttonClickCallback: pageClick});
                }
            }
        });
    }
    
    function submitForm(form, data, hasError) { 
        if (!hasError) {
             
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
     
   // $("#form").dialog({autoOpen: false, width: 350, position: ['center', 'middle'], modal: true});
   $("#form").dialog({autoOpen: false, width: 350,  modal: true});
   
    $("#btnNew").on("click", function() {
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");        
        resetForm("#form");
    });
    
   
    
    
    $(document).on("click", ".linkbtn_delete", function(e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if(answer){
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                        }
                    }
                }
            });
        }
    });
    
    
    
    //incomplete
    $(document).on("click", ".linkbtn_edit", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id"); 
        resetForm("#form"); 
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        populateForm("#form", data.data.result, "QACaptchaQuestion");
                        var cs = data.data.result.qa_casesensitive;
                        if(cs==1){
                            $("#QACaptchaQuestion_qa_casesensitive").prop('checked', true);
                        } else { 
                            $("#QACaptchaQuestion_qa_casesensitive").prop('checked', false);
                        }
                        $("#QACaptchaQuestion_qa_casesensitive").val("1");
                        $("#form").dialog("open");
                        $("#form").dialog("option", "title", "Edit");
                    } else {
                        alert("Not Found");
                    }
                }
            }
        });
    });
 
</script>
