<div class="btn-toolbar clearfix">    
    <button type="button" name="btnNew" id="btnNew" class="btn btn-primary">New User</button>  
</div>

<table class="table">
    <thead>
        <tr>
            <th class="col-xs-2">Actions</th>
            <th>Username</th>
            <th class="col-xs-2">Role</th>                     
            <th class="col-xs-2">Status</th>
        </tr>
    </thead>
    <tbody id="tbodyList">
        
    </tbody>
    <tfoot>
        <tr>
            <td colspan="4">
                <div id="pager" class="pager"></div>
            </td>
        </tr>
    </tfoot>
</table>

<!-- Templates -->
<p style="display:none">
    <textarea id="templateList" rows="0" cols="0">
<!--      
    {#foreach $T.records as r}
        <tr>
            <td>                
                <?php echo AdminHelpers::i()->linkbtnEdit('{$T.r.user_id}'); ?> 
                {#if $T.r.user_id > 1} 
                    <?php echo AdminHelpers::i()->linkbtnDelete('{$T.r.user_id}'); ?>
                {#/if}
                {#if $T.r.user_role != 'admin'} 
                    <?php echo AdminHelpers::i()->linkbtnOpen('{$T.r.user_id}',  urldecode($this->createUrl("tasks",array("user_id"=>'{$T.r.user_id}')))); ?>
                {#/if}
            </td>
            <td>{$T.r.user_name}</td>
            <td>{$T.r.user_role}</td>            
            <td>
                {#if $T.r.user_status == 'inactive'} 
                <span class="label label-warning">Inactive</span>
                {#else}
                <span class="label label-success">Active</span>
                {#/if} 
            </td>
        </tr> 
    {#/for}
-->
    </textarea>
</p>
<!-- //Templates -->


<?php
$form = $this->beginWidget('CActiveForm', array(
    'id' => 'form',
    'htmlOptions' => array('class' => 'dialog-form'),
    'action' => $this->createUrl("save"),
    'enableClientValidation' => true,
    'errorMessageCssClass' => "error",
    'clientOptions' => array(
        'validateOnSubmit' => true,
        'validateOnChange' => false,
        'afterValidate' => 'js:submitForm'
    )
        ));
?>
    <div class="clearfix"> 
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'user_name'); ?>
            <?php echo $form->textField($formModel, 'user_name', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'user_name'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'user_password'); ?>
            <?php echo $form->textField($formModel, 'user_password', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'user_password'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'user_email'); ?>
            <?php echo $form->textField($formModel, 'user_email', array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'user_email'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'user_role'); ?>
            <?php echo $form->dropDownList($formModel, 'user_role', array("user"=>"User","admin"=>"Admin"), array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'user_role'); ?>
        </div>
        <div class="form-group">
            <?php echo $form->labelEx($formModel, 'user_status'); ?>
            <?php echo $form->dropDownList($formModel, 'user_status', array("active"=>"Active","inactive"=>"Inactive"), array("class" => "form-control")); ?>
            <?php echo $form->error($formModel, 'user_status'); ?>
        </div>         
    </div> 
    <p class="text-right">
        <?php echo CHtml::submitButton("Submit", array("id" => "formbtnSubmit", "class" => "btn btn-primary")); ?>	
    </p>
    <?php echo $form->hiddenField($formModel, 'user_id'); ?>
<?php $this->endWidget(); ?>

    
<script>
 
    var page = 1;
    var total = 0;
    var perpage = <?php echo $this->perpage ?>;
    
    loadList(1);
    
    function getPageCount() {
        if (total > 0) {
            return Math.ceil(total /perpage);
        }
        return 0;
    }
    
    function pageClick(pageclickednumber) {
        $("#pager").pager({pagenumber: pageclickednumber, pagecount: getPageCount(), buttonClickCallback: pageClick});
        loadList(pageclickednumber);
    }
    
    function loadList(cpage){
        
        $.ajax({
            data: {"page": cpage },
            url: "<?php echo $this->createUrl("loadlist"); ?>",
            success: function(response, textStatus, XMLHttpRequest) {
                if (serverValidation(response) == true) {
                    if (response.status == true) {
                        
                        $("#tbodyList").setTemplateElement("templateList").processTemplate(response.data);
                        total = response.data.total;
                    } else {
                        $("#tbodyList").html("No Records Found");
                    }
                }

                page = cpage;
                if (page == 1) {
                    $("#pager").pager({pagenumber: page, pagecount: getPageCount(), buttonClickCallback: pageClick});
                }
            }
        });
    }
    
    function submitForm(form, data, hasError) { 
        if (!hasError) {
             
            form.ajaxSubmit({
                type:"post",
                dataType: "json",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                            $("#form").dialog("close");
                        }
                    }
                },
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        }
    }
     
  //  $("#form").dialog({autoOpen: false, width: 350, position: ['center', 'middle'], modal: true});
   $("#form").dialog({autoOpen: false, width: 350,  modal: true});
    $("#btnNew").on("click", function() {
        $("#form").dialog("open");
        $("#form").dialog("option", "title", "New");            
        resetForm("#form");
        $("#User_user_password").attr("placeholder","");
    });
    
   
    
    
    $(document).on("click", ".linkbtn_delete", function(e) {
        e.preventDefault();
        var answer = confirm("Are you sure?");
        if(answer){
            var id = $(this).attr("data-id");
            $.ajax({
                data: {"id": id},
                url: "<?php echo $this->createUrl("delete"); ?>",
                success: function(data, textStatus, XMLHttpRequest) {
                    if (serverValidation(data) == true) {
                        if (data.status == true) {
                            loadList(page);
                        }
                    }
                }
            });
        }
    });
    
    
    
    //incomplete
    $(document).on("click", ".linkbtn_edit", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id"); 
        resetForm("#form"); 
        $.ajax({
            data: {"id": id},
            url: "<?php echo $this->createUrl("get"); ?>",
            success: function(data, textStatus, XMLHttpRequest) {
                if (serverValidation(data) == true) {
                    if (data.status == true) {
                        populateForm("#form", data.data.result, "User");                         
                        $("#User_user_password").val("").attr("placeholder","*********");
                        $("#form").dialog("open");
                        $("#form").dialog("option", "title", "Edit");
                    } else {
                        alert("Not Found");
                    }
                }
            }
        });
    });
 
</script>

    