<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
        <title><?php echo $this->pageTitle; ?> - Control Panel
            <?php if(License::i()->license == License::PERSONAL) { 
                    echo " - Abhinav Software Epaper CMS"; } 
            ?></title> 
        <meta name="viewport" content="width=1040" />

        <?php        
        Yii::app()->getClientScript()->registerCoreScript("jquery");
        Yii::app()->getClientScript()->registerCoreScript("jquery.ui");        
        $scripts = array(   
            "js/jquery.form.js",
            "js/modernizr.min.js",
            "js/jquery_pager.js",
            "js/jquery.timepicker.js",
            "js/jquery-jtemplates.js",
            "js/lightbox/js/lightbox.min.js",
            "js/jquery.loadmask.min.js",            
            "bootstrap/js/bootstrap.min.js",
            'js/colorpicker/tinycolor-0.9.15.min.js',
            'js/colorpicker/pick-a-color-1.2.3.min.js',
            "js/AjaxOutput.script.js",
            "js/Helpers.script.js",   
            "js/html5shiv.min.js",
            "js/html5shiv-printshiv.min.js"
        );
        foreach($scripts as $script){
            Yii::app()->getClientScript()->registerScriptFile(AssetsManager::i()->getCoreAsset($script));
        }
        $styles = array(
            "css/normalize.css",
            "css/main.css",
            "bootstrap/css/bootstrap.min.css",
            "css/custom-theme/jquery-ui-1.9.2.custom.css", 
            "js/colorpicker/pick-a-color-1.2.3.min.css",           
            "js/lightbox/css/lightbox.css",
            "css/jquery.loadmask.css",
            "css/admin-style.css", 
            "css/jquery_pager.css",
            "js/jqtree/jqtree.css"
        );
        foreach($styles as $style){
            Yii::app()->getClientScript()->registerCssFile(AssetsManager::i()->getCoreAsset($style));
        } 
        ?>

        <style>
            
            .noTitle .ui-dialog-titlebar{
                display:none;
            }            
        </style>
        <script>
              $.fn.bootstrapBtn = $.fn.button.noConflict();
           $(document).ready(function(){
                
    
                $(document).ajaxStart(function() {      
                    $("body").mask("<img src='<?php echo AssetsManager::i()->getCoreAsset("images/ajax-loader.gif"); ?>' alt='...' /> Working... Please Wait!");
                               
                });
                $(document).ajaxStop(function() {
                    $("body").unmask();
                           
                });
                     });
                $.ajaxSetup({
                    type: "post",
                    dataType: "json",
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        showError(textStatus, errorThrown);
                    }
                });
           
        </script>
    </head>
    <body>
        <?php $this->widget('IEAlertWidget',array("ielevel"=>IEAlertWidget::IE7)); ?>
   
        

            <div id="header">
                <div class="container">
                <div class="row">
                    <div class="col-xs-4">
                        <a href="<?php echo Yii::app()->createUrl("//admin") ?>">
                            <img src="<?php echo License::i()->getAdminLogo(); ?>" alt="<?php echo Settings::i()->get("home_title"); ?>" />
                        </a>
                    </div>
                    <div class="col-xs-8 right-header">
                        <div class="btn-group">
                            <button type="button" class="btn btn-default dropdown-toggle" data-toggle="dropdown">
                              Welcome <?php echo Yii::app()->user->getState("identity")->user_name; ?>! <i class="glyphicon glyphicon-user"></i> <b class="caret"></b>
                            </button>
                            <ul class="dropdown-menu" role="menu">
                                <li><?php echo CHtml::link("My Account", $this->createUrl("//admin/default/account"), array("rel" => "nofollow")); ?></li>

                                <li class="divider"></li>
                                <li><?php echo CHtml::link("Sign Out", $this->createUrl("//main/signout"), array("rel" => "nofollow")); ?></li>
                            </ul>
                        </div>
                        <div class="btn-group">         
                            <?php                              
                            if(file_exists(Yii::getPathOfAlias("webroot")."/sitemap.xml")){                                   
                                echo CHtml::link("View Sitemap",Yii::app()->getBaseUrl(true)."/sitemap.xml",array("class"=>"btn btn-primary", "target"=>"_blank")); 
                            }
                            ?>
                        <?php echo CHtml::link("View Site", Yii::app()->getHomeUrl(),array("class"=>"btn btn-info", "target"=>"_blank")); ?>
                            </div>
                    </div>
                </div>
                </div>

                

            </div>
            

            <div id="mainmenu" class="navbar navbar-default navbar-inverse navbar-blue">
                <div class="container">
                <div class="navbar-inner">
                    <ul class="nav navbar-nav"> 
                        <li><?php echo CHtml::link("<span class='glyphicon glyphicon-home'></span>", $this->createUrl("//admin"), array("rel" => "nofollow")); ?></li>                        
                        <?php AdminMenu::i()->render(); ?>                         
                    </ul> 
                </div>
                </div>
            </div>

            <?php if (!Helpers::i()->isHomePage()) { ?>



                <div class="page-header">
                    <div class="container">
                    <h1><?php
                        echo htmlspecialchars($this->pageTitle);
                        ?></h1>
                    </div>

                </div>

            <?php } ?>

<div class="container">



            <?php $msg = Yii::app()->user->getFlash("success"); ?>
            <?php if ($msg != false) { ?>
                <div class="alert alert-success">
                    <?php echo $msg; ?>
                </div>
            <?php } ?>
            <?php $msg = Yii::app()->user->getFlash("error"); ?>
            <?php if ($msg != false) { ?>
                <div class="alert alert-danger">
                    <?php echo $msg; ?>
                </div>
            <?php } ?>


            <div id="main-container" style="min-height:800px; padding-top: 10px; padding-left:10px; padding-right: 10px; padding-bottom:10px; background-color: white; ">



                <?php echo $content; ?>


            </div>

            
        </div>


<div class="page-footer"> 
    <div class="container">
                <?php// echo License::i()->getAdminCredit(); ?>
                <?php echo "সকল কারিগরি সহযোগিতায়: <a href='https://www.creativedesign.com.bd' target='_blank' title='Mobile :+8801775457008'>ক্রিয়েটিভ ডিজাইন</a>"?>
                <br />
    </div>
             
            </div>


    </body>
</html>
