<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="utf-8" />
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1" />
        <title><?php echo $this->pageTitle; ?> - Control Panel</title> 
        <meta name="viewport" content="width=1040" />

        <?php
        Yii::app()->getClientScript()->registerCoreScript("jquery");
        Yii::app()->getClientScript()->registerCoreScript("jquery.ui"); 
        $scripts = array( 
            "bootstrap/js/bootstrap.min.js", 
            "js/html5shiv.min.js",
            "js/html5shiv-printshiv.min.js"
        );
        foreach($scripts as $script){
            Yii::app()->getClientScript()->registerScriptFile(AssetsManager::i()->getCoreAsset($script));
        }
        $styles = array(
            "css/normalize.css",
            "css/main.css",  
            "bootstrap/css/bootstrap.min.css",
            "css/custom-theme/jquery-ui-1.9.2.custom.css",             
            "css/admin-style.css",             
        );
        foreach($styles as $style){
            Yii::app()->getClientScript()->registerCssFile(AssetsManager::i()->getCoreAsset($style));
        } 
        ?>
        
        <script>
            $.ajaxSetup({
                type: "post",
                dataType: "json",
                error: function(XMLHttpRequest, textStatus, errorThrown) {
                    showError(textStatus, errorThrown);
                }
            });
        </script>
    </head>
    <body id="general">
        <?php $this->widget('IEAlertWidget',array("ielevel"=>IEAlertWidget::IE7)); ?>

        <div class="outer"> 
  
            <section>
                <div id="header">
                    <a href="<?php echo Yii::app()->createUrl("//admin") ?>">
                        <img src="<?php echo License::i()->getAdminLogo(); ?>" alt="<?php echo Settings::i()->get("home_title"); ?>" />
                    </a> 
                </div>
                <header class="page-header">
                    <h1><?php
                        echo htmlspecialchars($this->pageTitle);
                        ?></h1>

                </header>
                <?php $msg = Yii::app()->user->getFlash("success"); ?>
                <?php if ($msg != false) { ?>
                    <div class="alert alert-success">
                        <?php echo $msg; ?>
                    </div>
                <?php } ?>
                <?php $msg = Yii::app()->user->getFlash("error"); ?>
                <?php if ($msg != false) { ?>
                    <div class="alert alert-danger">
                        <?php echo $msg; ?>
                    </div>
                <?php } ?>
                <div class="content">
                    
                <?php echo $content; ?>
                        
                    </div>
                <footer class="page-footer">      
                    <?php echo License::i()->getAdminCredit(); ?>

                    <br />


                </footer>

            </section>


        </div>





    </body>
</html>
