<!DOCTYPE html>
<!--[if lt IE 7]>      <html class="no-js lt-ie9 lt-ie8 lt-ie7"> <![endif]-->
<!--[if IE 7]>         <html class="no-js lt-ie9 lt-ie8"> <![endif]-->
<!--[if IE 8]>         <html class="no-js lt-ie9"> <![endif]-->
<!--[if gt IE 8]><!--> <html class="no-js"> <!--<![endif]-->
    <head>
        <meta charset="utf-8">
        <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
        <title><?php echo $this->pageTitle; ?></title>
        <meta name="viewport" content="width=device-width">
        <?php        
        Yii::app()->getClientScript()->registerCoreScript("jquery");
        Yii::app()->getClientScript()->registerCoreScript("jquery.ui");        
        $scripts = array( 
            "bootstrap/js/bootstrap.min.js", 
            "js/html5shiv.min.js",
            "js/html5shiv-printshiv.min.js"
        );
        foreach($scripts as $script){
            Yii::app()->getClientScript()->registerScriptFile(AssetsManager::i()->getCoreAsset($script));
        }
        $styles = array( 
            "css/jquery.loadmask.css",
            "bootstrap/css/bootstrap.min.css",
            "css/custom-theme/jquery-ui-1.9.2.custom.css",             
            "css/public-style.css",             
        );
        foreach($styles as $style){
            Yii::app()->getClientScript()->registerCssFile(AssetsManager::i()->getCoreAsset($style));
        }  
        ?>
        <script type="text/javascript">var switchTo5x=true;</script>
        <script type="text/javascript" src="http://w.sharethis.com/button/buttons.js"></script>
        <script type="text/javascript">stLight.options({publisher: "ur-a0e1db14-14e3-4d34-19c0-5cc2f6d4b402", doNotHash: false, doNotCopy: false, hashAddressBar: false});</script>
         
        <?php echo BasicSettings::i()->code_at_head; ?>
    </head>

    <body>
        <?php $this->widget('IEAlertWidget',array("ielevel"=>IEAlertWidget::IE7)); ?>
        <header id="site-header">
            <div class="container">
                <div class="clear">
                    <div class="pull-left">
                        <?php 
                        if(trim(BasicSettings::i()->site_logo)!=""){
                            $logo = Yii::app()->getBaseUrl() . Yii::app()->params["uploadDir"] . BasicSettings::i()->site_logo; 
                            } else {
                            $logo = AssetsManager::i()->getCoreAsset("images/site-logo.png");   
                            }
                       ?>
                        <a  href="<?php echo Yii::app()->getHomeUrl(); ?>">
                            <img src="<?php echo $logo; ?>" alt="<?php echo BasicSettings::i()->site_title; ?>" />                            
                        </a> 
                    </div>
                    <div class="pull-right social">
                        <span class='st_sharethis_large' displayText='ShareThis'></span>
                        <span class='st_facebook_large' displayText='Facebook'></span>
                        <span class='st_twitter_large' displayText='Tweet'></span>
                        <span class='st_linkedin_large' displayText='LinkedIn'></span>
                        <span class='st_pinterest_large' displayText='Pinterest'></span>
                        <span class='st_email_large' displayText='Email'></span>
                    </div>
                </div>                
            </div>
        </header>

        <nav id="nav" class="navbar navbar-default navbar-inverse">
            <div class="container">
                <div class="navbar-inner">
                    <ul class="nav navbar-nav">
                        <li><?php echo CHtml::link("<span class='glyphicon glyphicon-home'></span>", Yii::app()->getHomeUrl(), array("rel" => "nofollow")); ?></li>
                        <?php echo MenuComponent::i()->render("default-menu"); ?>
                    </ul>
                </div>
            </div>
        </nav>  

 
        <article style="min-height:800px;" class="container">
                    <?php echo $content; ?>
        </article>
        <footer id="footer" class="well well-sm text-center">
           <?php echo License::i()->getPublicCredit(); ?>
        </footer>
        <?php echo BasicSettings::i()->code_at_foot; ?>
       
    </body>
</html>
