<?php

class ThemeFunctions extends AbstractSinglaton {

    public function loadAssets() {
        $clientScript = Yii::app()->getClientScript();
        $clientScript->registerCoreScript("jquery");
        $clientScript->registerCoreScript("jquery.ui");
        $clientScript->registerScriptFile(AssetsManager::i()->getCoreAsset("js/modernizr.min.js"));
        $clientScript->registerScriptFile(AssetsManager::i()->getCoreAsset("bootstrap/js/bootstrap.min.js"));
        $clientScript->registerCssFile($clientScript->getCoreScriptUrl() . '/jui/css/base/jquery-ui.css');
        $clientScript->registerCssFile(AssetsManager::i()->getCoreAsset("bootstrap/css/bootstrap.min.css"));
        $clientScript->registerCssFile(AssetsManager::i()->getCoreAsset("/css/hover.css"));
        $clientScript->registerCssFile(AssetsManager::i()->getCoreAsset("style.css"));
        $clientScript->registerScriptFile(AssetsManager::i()->getCoreAsset("js/html5shiv.min.js"));
        $clientScript->registerScriptFile(AssetsManager::i()->getCoreAsset("js/html5shiv-printshiv.min.js"));
        $clientScript->registerCssFile(AssetsManager::i()->getCoreAsset("css/jquery.loadmask.css"));
        $clientScript->registerScriptFile(AssetsManager::i()->getCoreAsset("js/jquery.loadmask.min.js"));
        $clientScript->registerScriptFile(AssetsManager::i()->getModuleAsset("epaper", "colorbox/jquery.colorbox-min.js"));
        $clientScript->registerCssFile(AssetsManager::i()->getModuleAsset("epaper", "colorbox/example3/colorbox.css"));
        $clientScript->registerCssFile(AssetsManager::i()->getCoreAsset("font-awesome/css/font-awesome.min.css"));
        $clientScript->registerCssFile("https://fonts.googleapis.com/css?family=" . Press_ThemeSettings::i()->f_body . ":300,400,700");
        $clientScript->registerCssFile("https://fonts.googleapis.com/css?family=" . Press_ThemeSettings::i()->f_heading . ":300,400,700");
    }

    public function renderStyle() {
        ?>
        <style>
            body{
                background-color:#<?php echo BackgroundSettings::i()->bg_color ?>;
                background-image:url(<?php echo Yii::app()->getBaseUrl(true) . Yii::app()->params["uploadDir"] . BackgroundSettings::i()->bg_image ?>);
                background-repeat:<?php echo BackgroundSettings::i()->bg_image_repeat ?>;
                background-position:<?php echo BackgroundSettings::i()->bg_image_position ?>;       
                background-attachment: <?php echo BackgroundSettings::i()->bg_image_attachment ?>;    
                font-family:'<?php echo Press_ThemeSettings::i()->f_body ?>';
            }
            .page_heading, .epost-title a, .subcategory-block h3 a, .title-header, #page-heading-inner, .widget_title, .fcategorylist-block h4, .page-heading{
                font-family:'<?php echo Press_ThemeSettings::i()->f_heading ?>';
            }
            a{
                color:#<?php echo Press_ThemeSettings::i()->c_link ?>;
            }
            a:hover{
                color:#<?php echo Press_ThemeSettings::i()->c_link_hover ?>;
            }
            .epost-title a, .subcategory-block h3 a, .fcategorylist-block h4 a, .widget_title i{
                color:#<?php echo Press_ThemeSettings::i()->c_base ?>;                 
            } 
            .page-heading, #mainmenu,  .title-header{
                border-top-color: #<?php echo Press_ThemeSettings::i()->c_base ?>;                
            } 
            .navbar-btn2, .navbar-btn2:hover, .navbar-btn2:focus, .navbar-btn2:active, .open .dropdown-toggle.navbar-btn2{
                background-color: #<?php echo Press_ThemeSettings::i()->c_base ?>;
            }
             

            /******************************/
            /* PAGINATION CONTROL STYLING */
            /******************************/

            .pagination > li > a, 
            .pagination > li > span{
                color: #<?php echo Press_ThemeSettings::i()->c_base ?>;
            }
            .pagination > li > a:hover, 
            .pagination > li > span:hover{
                color: #<?php echo Press_ThemeSettings::i()->c_base ?>;
            }
            .pagination > .active > a, 
            .pagination > .active > span, 
            .pagination > .active > a:hover, 
            .pagination > .active > span:hover, 
            .pagination > .active > a:focus, 
            .pagination > .active > span:focus{
                background-color: #<?php echo Press_ThemeSettings::i()->c_base ?>;    
                border-color: #<?php echo Press_ThemeSettings::i()->c_base ?>;
            }



        </style>

        <?php
    }

     

    public function dateArchive() {
        $currentDate = Yii::t("theme_press","Archive");
        if (Yii::app()->request->getParam("archive") != "") {
            $currentDate = Helpers::i()->formatDate(Yii::app()->request->getParam("archive"), "d M Y");
        }
        if (GlobalVar::i()->currentDate != "" || GlobalVar::i()->currentDate != false) {
            $currentDate = Helpers::i()->formatDate(GlobalVar::i()->currentDate, "d M Y");
        }
            
        if (Press_ThemeSettings::i()->archive_type == Press_ThemeSettings::ARC_CALENDER) { 
            Yii::app()->controller->widget('CalenderWidget', array(
                "id" => "topcalender",
                "btnClass" => "btn btn-primary navbar-btn2 btnTopCalender",
                "btnLabel" => '<span class="glyphicon glyphicon-calendar"></span> ' . Yii::t("theme_press", "Archive"),
                "currentDate" => $currentDate,
            ));
        } else if(Press_ThemeSettings::i()->archive_type == Press_ThemeSettings::ARC_DDLIST){  
            Yii::app()->controller->widget('CalenderDropdown', array(
                "id" => "topcalender",
                "class"=>"navbar-btn2",
                "currentDate" => $currentDate,
                "count" => Press_ThemeSettings::i()->archive_ddlist_count
            ));
        }
    }

    public function categoryMenu() {
        ?>


        <?php if (Press_ThemeSettings::i()->show_category_menu) { ?>
            <?php $catlist = EpaperCategory::model()->getFullHierarchyAsPlainArray(0, false); ?>
            <div class="btn-group">
                <button type="button" class="btn navbar-btn2 btn-danger btn-catmenu  dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <?php echo Yii::t("theme_press", "Select Category") ?><span class="caret"></span>
                </button>
                <ul class="dropdown-menu">
            <?php foreach ($catlist as $k => $v) { ?>
                        <li class="catlist text-left"><a data-id="<?php echo $k ?>" href="#"><?php echo $v; ?></a></li>
                    <?php } ?>
                </ul>
            </div>
            <script>
                $(".catlist a").on("click", function (e) {
                    e.preventDefault();
                    var cat_id = $(this).attr("data-id");
                    url = "<?php echo Yii::app()->controller->createUrl("//epaper/default/index", array("id" => "CATID", "alias" => "xxx")) ?>";
                    window.location = url.replace("CATID", cat_id);
                });
            </script>
        <?php } ?>

        <?php
    }

}
