<?php
/*
Application Developed By Abhinav Software
Website: http://abhinavsoftware.com
Email: contact@abhinavsoftware.com
Developer: Ankur Gupta (ankurgupta555@gmail.com)
Copyright Ankur Gupta

For licensing and terms of use please read license.txt file
*/
class Press_ThemeSettings extends AbstractAdminSettingsForm {
 
      
    
    public $show_credit = true;
    public $show_breadcrumb = true;
    public $show_pagetitle = true;
    public $show_page_socialicons = true;
    
    const ARC_CALENDER = "calender";
    const ARC_DDLIST = "ddlist";
    const ARC_NONE = "none";    
    public $archive_type = self::ARC_CALENDER;    
    public $archive_ddlist_count = 25;
    
    
    
    
    public $show_category_menu = true;

    public $enable_ajax = true;
    
    public $ad_top;
    public $ad_menu;
    public $ad_left;
    public $ad_right;
    
    public $c_link = "1570A6";
    public $c_link_hover = "1570A6";    
    public $c_base = "1570A6";
    
    public $f_body = "Roboto";
    public $f_heading = "Roboto";
    
    public $layout_home = self::PGL_SIDEBAR;
    public $layout_epaper_archive = self::PGL_SIDEBAR;
    public $layout_epaper_page  = self::PGL_NONE;
    public $layout_single_page  = self::PGL_NONE;
    
    public $text_fedition = "Featured Editions";
    public $text_fcategory = "Featured Categories";
    
    const PGL_SIDETHUMB = "sidethumb";
    const PGL_SIDEBAR = "sidebar";
    const PGL_NONE = "none";    
    
    public function rules() {
        $rules = parent::rules();
        $rules[] = array("c_link, archive_type, archive_ddlist_count, c_link_hover, c_base, f_body, f_heading", "required");

        $rules[] = array("ad_top, ad_menu, ad_left, ad_right, enable_ajax, show_credit, show_breadcrumb, text_fedition, text_fcategory, "
            . "layout_home, layout_epaper_archive, layout_epaper_page, layout_single_page, "
            . "show_pagetitle, show_page_socialicons, show_category_menu", "length", "allowEmpty" => true);
     
        return $rules;
    }

    public function attributeLabels() {
        $l = parent::rules();
      
        $l["ad_top"] = "Ad on Top";
        $l["ad_menu"] = "Ad below Menu";
        
        $l["ad_left"] = "Left Ad";
        $l["ad_right"] = "Right Ad";
        
 
        $l["archive_ddlist_count"] = "Dropdown Archive Count";
        
        $l["layout_home"] = "Homepage";
        $l["layout_epaper_archive"] = "Epaper Archive";
        $l["layout_epaper_page"] = "Epaper Page";
        $l["layout_single_page"] = "Single Page";
        
        $l["text_fedition"] = "Featured Editions";
        $l["text_fcategory"] = "Featured Categories";
        
        $l["c_link"] = "Link";
        $l["c_link_hover"] = "Link Hover";
        $l["c_base"] = "Base";
        
        $l["f_body"] = "Body Font";
        $l["f_heading"] = "Heading Font";
        
        $l["enable_ajax"] = "Enable Ajax On Epaper";
        
        return $l;
    }

    public function adminForm() { 
       
        $boolList = array(
            "yes" => "Yes",
            "no" => "No"
        );
       
        $ltList1 = array(            
            self::PGL_SIDEBAR => "Sidebar",
            self::PGL_NONE => "None"
        );
        
        $ltList2 = array(
            self::PGL_SIDETHUMB => "Side Thumbnail",
            self::PGL_SIDEBAR => "Sidebar",
            self::PGL_NONE => "None"
        );
        
        echo "<fieldset><legend>Show/Hide</legend>";
        
            echo "<div class='row'>";        
            $shows = ["breadcrumb","pagetitle","page_socialicons","category_menu","credit"];
            foreach($shows as $r){
                echo "<div class='col-xs-6'>";
                    echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->checkBox($this, "show_".$r);
                    echo "&nbsp;" . $this->form->label($this, "show_".$r);
                    echo $this->form->error($this, "show_".$r);
                    echo CHtml::closeTag("div");                
                echo "</div>";
            }

            echo "<div class='col-xs-12'>";
                    foreach(["ad_top","ad_menu","ad_left","ad_right"] as $ad){ 
                        echo CHtml::openTag("div", array("class" => "form-group"));
                            echo $this->form->label($this, $ad);
                            echo $this->form->textArea($this, $ad, array("class" => "form-control"));
                            echo $this->form->error($this, $ad);
                        echo CHtml::closeTag("div");
                    }
                echo "</div>";
            echo "</div>";
        
        echo "</fieldset>";
        
        echo CHtml::openTag("div", array("class" => "form-group"));
            echo $this->form->checkBox($this, "enable_ajax");
            echo "&nbsp;" . $this->form->label($this, "enable_ajax");
            echo $this->form->error($this, "enable_ajax" . $r);
        echo CHtml::closeTag("div");


        echo "<fieldset><legend>Layouts</legend>";        
        echo "<div class='row'>";        
        $shows = ["layout_home","layout_epaper_archive","layout_epaper_page","layout_single_page"];
        foreach($shows as $r){
            echo "<div class='col-xs-6'>";
                echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->label($this, $r);
                    if($r=="layout_epaper_page"){
                        echo $this->form->dropDownList($this, $r, $ltList2,array("class" => "form-control"));
                    } else {
                        echo $this->form->dropDownList($this, $r, $ltList1,array("class" => "form-control"));
                    }
                    echo $this->form->error($this, $r);
                echo CHtml::closeTag("div");               
            echo "</div>";
        }
        echo "</div>";        
        echo "</fieldset>";
        
        
        echo "<fieldset><legend>Featured Titles</legend>";        
        echo "<div class='row'>";        
        $shows = ["text_fedition","text_fcategory"];
        foreach($shows as $r){
            echo "<div class='col-xs-6'>";
                echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->label($this, $r);
                    echo $this->form->textField($this, $r, array("class" => "form-control"));
                    echo $this->form->error($this, $r);
                echo CHtml::closeTag("div");               
            echo "</div>";
        }
        echo "</div>";        
        echo "</fieldset>";
        
        
        echo "<fieldset><legend>Colors</legend>";        
        echo "<div class='row'>";        
        $shows = ["c_link","c_link_hover","c_base"];
        foreach($shows as $r){
            echo "<div class='col-xs-6'>";
                echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->label($this, $r);
                    echo $this->form->textField($this, $r, array("class" => "form-control"));
                    echo $this->form->error($this, $r);
                echo CHtml::closeTag("div");               
            echo "</div>";
        }
        echo "</div>";        
        echo "</fieldset>";
        
        
        
        $fontlist = Helpers::i()->listGoogleFonts();
        
        echo "<fieldset><legend>Fonts</legend>";        
        echo "<div class='row'>";        
        $shows = ["f_body","f_heading"];
        foreach($shows as $r){
            echo "<div class='col-xs-6'>";
                echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->label($this, $r);                   
                    echo $this->form->dropDownList($this, $r, $fontlist,array("class" => "form-control"));                    
                    echo $this->form->error($this, $r);
                echo CHtml::closeTag("div");               
            echo "</div>";
        }
        echo "</div>";        
        echo "</fieldset>";
        
        echo "<fieldset><legend>Archives</legend>";        
        echo "<div class='row'>";              
            echo "<div class='col-xs-6'>";
                echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->label($this, "archive_type");
                    echo $this->form->dropDownList($this, "archive_type", [
                        self::ARC_CALENDER => "Calender", self::ARC_DDLIST => "Dropdown List", self::ARC_NONE => "None"
                    ],array("class" => "form-control"));
                    echo $this->form->error($this, "archive_type");
                echo CHtml::closeTag("div");
            echo "</div>";
            echo "<div class='col-xs-6'>";
                echo CHtml::openTag("div", array("class" => "form-group"));
                    echo $this->form->label($this, "archive_ddlist_count");
                    echo $this->form->textField($this, "archive_ddlist_count",array("class" => "form-control"));
                    echo $this->form->error($this, "archive_ddlist_count");
                echo CHtml::closeTag("div");
            echo "</div>";
            
        echo "</div>";        
        echo "</fieldset>";
        
        
        
        
        
        ?>
        <script type="text/javascript">
            $(document).ready(function() {
                $("#<?php echo get_class($this) ?>_c_link, #<?php echo get_class($this) ?>_c_link_hover, #<?php echo get_class($this) ?>_c_base").pickAColor({
                    showSavedColors: false,
                });
            });
        </script>
        <?php
    }

}
