<?php
Yii::import("webroot.themes.press.ThemeFunctions");
$config = ModuleLoader::getConfig("epaper");
$uploadDir = Yii::app()->params["uploadDir"];
$mediaDir = $config["mediaDir"];
$baseUrl = Yii::app()->getBaseUrl(true);

$img_width = 130;
?>

<article>
    <header class="page-title">
        <h1 class="page-heading"><?php echo CHtml::encode($pagetitle); ?></h1>
    </header> 
    
            <?php
            if (count($data["records"]) > 0) {
                foreach ($data["records"] as $r) {
                    if (trim($r["mp_image"]) == "") {
                        $thumburl = $this->createAbsoluteUrl("viewmap", array("id" => $r["mp_id"], "resize" => "yes", "width" => $img_width, "height" => $img_width, "crop" => "yes"));
                    } else {
                        $imgurl = $baseUrl . $uploadDir . $mediaDir . $r["mp_image"];
                        $thumburl = ImageHelpers::i()->getThumbImage($imgurl, $img_width, $img_width, true);
                    }
                    ?>

                    <section class="pbox row">
                        <div class="pbox-thumb col-xs-2">
                            <a class='area'
                               data-x='<?php echo $r["mp_x"] ?>' 
                               data-y='<?php echo $r["mp_y"] ?>' 
                               data-h='<?php echo $r["mp_h"] ?>' 
                               data-w='<?php echo $r["mp_w"] ?>'
                               data-id='<?php echo $r["mp_id"] ?>' 
                               data-alias='<?php echo $r["mp_alias"] ?>' href="<?php echo $this->createUrl("map", array("id" => $r["mp_id"], "alias" => $r["mp_alias"])) ?>">
        <?php echo CHtml::image($thumburl, CHtml::encode($r["mp_title"]), array("class" => "thumbnail")) ?>
                            </a>
                        </div>
                        <div class="pbox-details col-xs-8">
                            <header><h1 class="pbox-title"><a class='area'
                                                              data-x='<?php echo $r["mp_x"] ?>' 
                                                              data-y='<?php echo $r["mp_y"] ?>' 
                                                              data-h='<?php echo $r["mp_h"] ?>' 
                                                              data-w='<?php echo $r["mp_w"] ?>'
                                                              data-id='<?php echo $r["mp_id"] ?>' 
                                                              data-alias='<?php echo $r["mp_alias"] ?>' href="<?php echo $this->createUrl("map", array("id" => $r["mp_id"], "alias" => $r["mp_alias"])) ?>"><?php echo CHtml::encode($r["mp_title"]) ?></a></h1></header>
        <?php
        if (trim($r["mp_desc"]) != "") {
            echo "<p class='pbox-desc'>" . Helpers::i()->wordLimiter(CHtml::encode($r["mp_desc"]),50) . "</p>";
        }
        ?>
                            <div class="pbox-data">
                                <?php echo CHtml::link(CHtml::encode($r["ed_title"]), $this->createUrl("//epaper/default/show", array("id" => $r["ed_id"], "alias" => $r["ed_alias"]))) ?> 
                                / <?php echo CHtml::link(CHtml::encode($r["cat_title"]), $this->createUrl("//epaper/default/index", array("id" => $r["cat_id"], "alias" => $r["cat_alias"]))) ?>
                            </div>
                        </div> 
                    </section>

                    <?php
                }
            } else {
                ?>

                <div class='well'>
                    <?php echo Yii::t("epaper", "No Results Found") ?>
                </div>

            <?php } ?>
            <?php
            $this->widget('CLinkPager', array(
                'pages' => $pagination,
                'cssFile' => false,
                'header' => false,
                'hiddenPageCssClass' => 'disabled',
                'selectedPageCssClass' => 'active',
                'htmlOptions' => array("class" => "pagination")
            ));
            ?>
         
</article>


<?php if(EpaperPopupSettings::i()->enable_dialog == false){ ?>
<script>
    $(document).ready(function () {
        $(document).on("click", ".area", function (e) {
            e.preventDefault();
            var x = $(this).attr("data-x");
            var y = $(this).attr("data-y");
            var w = $(this).attr("data-w");
            var h = $(this).attr("data-h");

            var w2 = parseFloat(w) + parseFloat(<?php echo EpaperPopupSettings::i()->extra_width; ?>);
            var h2 = parseFloat(h) + parseFloat(<?php echo EpaperPopupSettings::i()->extra_height; ?>);

            if (w2 <<?php echo EpaperPopupSettings::i()->minimum_width; ?>) {
                w2 = <?php echo EpaperPopupSettings::i()->minimum_width; ?>;
            }

            if (h2 <<?php echo EpaperPopupSettings::i()->minimum_height; ?>) {
                h2 = <?php echo EpaperPopupSettings::i()->minimum_height; ?>;
            }

            var id = $(this).attr("data-id");
            var alias = $(this).attr("data-alias");

            var url = "<?php echo urldecode(Yii::app()->createUrl("//epaper/default/map", array("id" => "[id]", "alias" => "[alias]"))); ?>"
            url = url.replace("[id]", id);
            url = url.replace("[alias]", alias);

            var left = (screen.width/2)-(w/2);
            var top = (screen.height/2)-(h/2);
            if(w2 > screen.width){
                w2 = screen.width - 100;
            }
            if(h2 > screen.height){
                h2 = screen.height - 150;
            }
        
            h = parseInt(h) + 55;

            window.open(url, "_blank", 'width=' + w2 + ',height=' + h2 + ',toolbar=0,menubar=0,location=0,status=0,scrollbars=1,resizable=1,left=' + left + ',top=' + top);
            return false;
        });
    });
</script>

<?php } else { ?>


<style>
    .pdialog.ui-dialog .ui-dialog-content{
        padding:0px;
        overflow:hidden;                
    }    
    .pdialog.ui-dialog {
        box-shadow: 0px 0px 10px rgba(0,0,0,0.5);
      
        position:fixed;
    }
</style>
 

<div id="dialogWindow" title="<?php echo Yii::app()->controller->pageTitle ?>">
    <iframe style="width:100%; height:100%; border:none">
    </iframe>
</div>
  
<script>
$(document).ready(function(){
    
    $("#dialogWindow").dialog({
       autoOpen:false, modal:true,dialogClass:"pdialog",
       width:<?php echo EpaperPopupSettings::i()->dialog_width ?>, height:<?php echo EpaperPopupSettings::i()->dialog_height ?>,
    });
    $(".area").on("click", function(e) {
        e.preventDefault();
        var id = $(this).attr("data-id");
        var alias = $(this).attr("data-alias");

        var url = "<?php echo urldecode(Yii::app()->createUrl("//epaper/default/map",array("id"=>"[id]","alias"=>"[alias]"))); ?>"
        url = url.replace("[id]",id);
        url = url.replace("[alias]",alias);
        
        $("#dialogWindow").dialog("open");
        $("#dialogWindow iframe").attr("src",url);
    });
});    
</script>


<?php } ?>
