<?php
$epaper_config = ModuleLoader::getConfig("epaper");
$epaper_mediadir = Yii::app()->getBaseUrl(true) . Yii::app()->params['uploadDir'] . $epaper_config["mediaDir"];
?>
<article class="edition-block">
    <header class="page-title">
        <h1 class="page-heading"><span id="page-heading-inner" class="page-heading-inner"><?php echo CHtml::encode($pagetitle); ?></span>
            <span class="edition_date"><?php echo Helpers::i()->formatDate($edition_model->ed_date, "F d, Y"); ?></span>
        </h1>         
        <?php if (trim($edition_model->ed_desc) != "") { ?>
            <div class="description">
                <?php echo Helpers::i()->makeLinksActive(CHtml::encode($edition_model->ed_desc)); ?>
            </div>
        <?php } ?>
    </header>
    <div class="toolbar_area" id="toolbar_area">
        <?php include "show_toolbar.php"; ?>    
    </div>
    <div class="row">
        <?php
        $x = 12;
        $containerWidth = 930;
        if (Press_ThemeSettings::i()->layout_epaper_page == Press_ThemeSettings::PGL_SIDEBAR) {
            $x = 8;
            $containerWidth = 610;
        } else if (Press_ThemeSettings::i()->layout_epaper_page == Press_ThemeSettings::PGL_SIDETHUMB) {
            $x = 10;
            $containerWidth = 770;
        }
        ?>        

        <?php if (Press_ThemeSettings::i()->layout_epaper_page == Press_ThemeSettings::PGL_SIDETHUMB) { ?>
            <div class="col-xs-2">
                <?php include "show_thumb.php" ?>
            </div>
        <?php } ?>

        <div class="col-xs-<?= $x ?>">
            <div class="page_area" id="page_area">

                <?php
                $suppEditions = EpaperSupp::getSuppsFromEdition($edition_model->ed_id);
           
                $homeurl = $this->createUrl("//epaper/default/show", array("id" => $edition_model->ed_id, "alias" => $edition_model->ed_alias));
                if (count($suppEditions) > 0) {
                    ?>                
                    <ul class="nav nav-tabs supptabs">
                        <li role="presentation" data-spid="0" class="<?php
                        if ($spid == 0) {
                            echo "active";
                        }
                        ?>"><a data-spid="0" href="<?php echo $homeurl; ?>"><span class="glyphicon glyphicon-home"></span></a></li>
                            <?php
                            foreach ($suppEditions as $se) {
                                $spurl = $this->createUrl("//epaper/default/show", array("id" => $edition_model->ed_id, "alias" => $edition_model->ed_alias,
                                    "spid" => $se["sp_id"], "spalias" => $se["sp_alias"]
                                ));
                                ?>
                            <li role="presentation" data-spid="<?php echo $se["sp_id"] ?>" class="<?php
                            if ($spid == $se["sp_id"]) {
                                echo "active";
                            }
                            ?>"><a data-spid="<?php echo $se["sp_id"] ?>" href="<?php echo $spurl ?>"><?php echo $se["sp_name"]; ?></a></li>
                            <?php } ?>
                    </ul> 
                <?php } ?>


                <?php if (Press_ThemeSettings::i()->show_pagetitle) { ?>
                    <div class="page-title2 clearfix">
                        <h2 class="page-heading2"><?php
                            if (trim($current_page_model->pg_title) == "") {
                                echo Yii::t("theme_press", "Page") . " " . $page;
                            } else {
                                echo CHtml::encode($current_page_model->pg_title);
                            }
                            ?></h2>
                    </div>        
                    <?php if (trim($current_page_model->pg_desc) != "") { ?>
                        <div class="description">
                            <?php echo Helpers::i()->makeLinksActive(CHtml::encode($current_page_model->pg_desc)); ?>
                        </div>
                    <?php } ?>
                <?php } ?>



                <?php
                if (Press_ThemeSettings::i()->show_page_socialicons) {
                    $this->widget('ShareItWidget', array(
                        'link' => Yii::app()->request->hostInfo . Yii::app()->request->url,
                        'fontsize' => "20px",
                        'title' => $edition_model->ed_title." - ".$current_page_model->pg_title." - ".BasicSettings::i()->site_title,
                    ));
                }
                $this->widget('EpaperPageWidget', array(
                    'pageModel' => $current_page_model,
                    'containerWidth' => $containerWidth,
                    'canvasClass' => 'can'
                ));
                ?>

            </div>
        </div>

            <?php if (Press_ThemeSettings::i()->layout_epaper_page == Press_ThemeSettings::PGL_SIDEBAR) { ?>        
            <div class="col-xs-4">
            <?php echo PanelComponent::i()->render("showpage-panel") ?>
            </div>
<?php } ?>

    </div>
</article>

<script>


<?php if (Press_ThemeSettings::i()->enable_ajax) { ?>

        var page_models = [];
        updatePageModels();
        var current_page_model = page_models[0][0];
        var spid = 0;
        var spalias = "";
        var page = 1;

        function updatePageModels() {
            var str = [];
    <?php
    foreach ($page_models as $spid => $pgms) {
        $n = 1;
        foreach ($page_models[$spid] as $pm) {
            $imgsrc = $epaper_mediadir . $pm->pg_file;
            $thumbsrc = ImageHelpers::i()->getThumbImage($imgsrc, 93);
            $imgtag = CHtml::image($thumbsrc, $pm->pg_title, array("class" => ""));

            $params = array("id" => $id, "alias" => $alias, "page" => $n);

            if ($spid > 0) {
                $params["spid"] = $spid;
                $params["spalias"] = $spalias;
            }
            $attr["class"] = "pagethumb thumbnail";
            if (Yii::app()->request->getParam("page", 1) == $n) {
                $attr["class"] = "current pagethumb thumbnail";
            }

            foreach ($params as $k => $v) {
                $attr["data-" . $k] = $v;
            }
            if ($n == 1) {
                echo "str[" . $spid . "] = '<div class=\"pg_title text-center\">". $pm->pg_title. "</div>" . CHtml::link($imgtag, $this->createUrl("//epaper/default/show", $params), $attr) . "';\n";
            } else {
                echo "str[" . $spid . "] += '<div class=\"pg_title text-center\">". $pm->pg_title. "</div>" . CHtml::link($imgtag, $this->createUrl("//epaper/default/show", $params), $attr) . "';\n";
            }
            $n++;
        }
    }
    ?>
            page_models = str;
        }


        $(document).on("click", ".rthumb_bar .thumbnail, #thumbnail_browser .thumbnail", function (e) {
            e.preventDefault();

            loadPage($(this).attr("href"));

            $("a").removeClass("current");
            $(this).addClass("current");
        });
        
        $(document).on("click", ".bookmarklist a", function (e) {
            e.preventDefault();

            loadPage($(this).attr("href"),true);

            $("a").removeClass("current");
            $(this).addClass("current");
        });
        
        
        $(document).on("click", ".pagination a", function (e) {
            e.preventDefault();
            loadPage($(this).attr("href"));
        });
        $(document).on("click", ".supptabs a", function (e) {
            e.preventDefault();
            var spid = $(this).data("spid");
            var url = $(this).attr("href");
            //    $(".supptabs li").removeClass("active");
            //  $("li[data-spid=" + spid + "]").addClass("active");
            loadPage(url,true)
            //    $(".rthumb_bar").html(page_models[spid]);            
        });


        function loadPage(url,loadthumb) {
            $(".loading").dialog("open");
            $.ajax({
                url: url,
                dataType: "json",
                success: function (response) {
                    $(".modal-backdrop").hide();
                    $('#thumbnail_browser').modal("hide");
                    $('body').removeClass('modal-open');
                    
                    //document.getElementById("page_area").innerHTML = response.data.result.ajax1;
                    $("#page_area").html(response.data.result.ajax1);
                    document.getElementById("toolbar_area").innerHTML = response.data.result.ajax2;
                    document.getElementById("page-heading-inner").innerHTML = response.data.result.pagetitle;
                    $("title").html(response.data.result.title);
                    $(".loading").dialog("close");
                     
                    if(loadthumb===true){
                        $(".rthumb_bar").html(page_models[response.data.result.spid]);
                    }
                    $(".rthumb_bar a").removeClass("current");
                    $("a[data-page=" + response.data.result.page + "]").addClass("current");
                    $(".rthumb_bar").scrollTo('.current');
                    
               
//                    $("img[usemap]").mapster({ 
//                        stroke: true,
//                        strokeColor: "E32B25",
//                         
//                        strokeOpacity: 1,
//                        strokeWidth: 2,
//                        fillOpacity: 0,
//                        fade:false
//                    }); 

                    window.history.pushState({"html": "", "pageTitle": response.data.result.title}, "", url);
                }
            });
        }

<?php } ?>

    function highlightCurrentThumb(url) {
        $("a").removeClass("current");
        $("a").each(function () {
            if ($(this).attr("href") === url) {
                $(this).addClass("current");
            }
        });
        $(".rthumb_bar").scrollTo('.current');
    }


    $(document).ready(function () {
        $("select[name=category]").val("<?php echo $edition_model->cat_id ?>");
    });
    $('.imagethumb').colorbox();
    $(document).on("click", ".cboxPhoto", function () {
        $.colorbox.close();
        $(".loading").dialog("close");
    });
    $(document).bind('cbox_closed', function () {
        $(".loading").dialog("close");
    });



</script>